<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Customer\Collection;


use Doctrine\ORM\QueryBuilder;
use MotoStore\Collection\Collection;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class Customer implements FactoryInterface
{
    /**
     * Create service
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService (ServiceLocatorInterface $serviceLocator)
    {
        $collection = new Collection ();

        /** @var QueryBuilder $queryBuilder */
        $queryBuilder = $serviceLocator
            ->get ('MotoStore\EntityManager')
            ->createQueryBuilder ();

        $query = $queryBuilder
            ->select (array ('c', 'cn', 'st', 's'))
            ->from ('MotoStore\Customer\Entity\Customer', 'c')
            ->leftJoin ('c.country', 'cn')
            ->leftJoin ('cn.states', 'st')
            ->leftJoin ('c.state', 's');

        $collection->setQuery ($query);

        $collection->setPropertiesMap (array (
            'email'         => 'c.email',
            'first_name'    => 'c.first_name',
            'last_name'     => 'c.last_name',
            'phone'         => 'c.contact_phone',
            'contact_phone' => 'c.contact_phone',
            'btob'         => 'c.btob',
            'active'         => 'c.active',
            'custom_information' => 'c.custom_information',
        ));

        return $collection;
    }
}