<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Customer\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use MotoStore\Localization\Entity\Country;
use MotoStore\Localization\Entity\State;

/**
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks()
 * @ORM\Table(name="store_customer",options={"engine":"InnoDB"})
 */
class Customer
{

    const GENDER_MALE   = 1;
    const GENDER_FEMALE = 2;

    const CUSTOMER_ACTIVE       = 1;
    const CUSTOMER_NOT_ACTIVE   = 0;

    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @var string
     * @ORM\Column(type="string")
     */
    protected $email;

    /**
     * @var string
     * @ORM\Column(type="string", nullable=true)
     */
    protected $password;

    /**
     * @var boolean
     * @ORM\Column(type="boolean") */
    protected $active;

    /**
     * @var \DateTime
     * @ORM\Column(type="datetime")
     */
    protected $created_at;

    /**
     * @var \DateTime
     * @ORM\Column(type="datetime")
     */
    protected $updated_at;

    /** @ORM\Column(type="integer", nullable=true) */
    protected $gender;

    /** @ORM\Column(type="integer", nullable=true) */
    protected $age;

    /** @ORM\Column(type="boolean") */
    protected $newsletter = 0;

    /** @ORM\Column(type="boolean", nullable=true) */
    protected $btob = 0;

    /** @ORM\Column(type="integer", nullable=true) */
    protected $discount;

    /**
     * @var string
     * @ORM\Column(type="string")
     */
    protected $first_name;

    /**
     * @var string
     * @ORM\Column(type="string", nullable=true)
     */
    protected $last_name;

    /** @ORM\Column(type="string", nullable=true) */
    protected $company;

    /** @ORM\Column(type="string", nullable=true) */
    protected $address1;

    /** @ORM\Column(type="string", nullable=true) */
    protected $address2;

    /** @ORM\Column(type="string", nullable=true) */
    protected $post_code;

    /** @ORM\Column(type="string", nullable=true) */
    protected $city;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Localization\Entity\Country")
     * @ORM\JoinColumn(name="country_id", referencedColumnName="id", onDelete="SET NULL")
     */
    protected $country;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Localization\Entity\State")
     * @ORM\JoinColumn(name="state_id", referencedColumnName="id", onDelete="SET NULL")
     */
    protected $state;

    /** @ORM\Column(type="string", nullable=true) */
    protected $contact_phone;

    /** @ORM\Column(type="string", nullable=true) */
    protected $loyalty_discount;

    /** @ORM\Column(type="text", nullable=true) */
    protected $wish_list;


    /** @ORM\Column(type="text", nullable=true) */
    protected $custom_information;

    /**
     * @ORM\OneToMany(targetEntity="MotoStore\Order\Entity\Order", mappedBy="customer")
     */
    protected $orders;

    public function __construct ()
    {
        $this->orders   = new ArrayCollection ();
    }

    public function getFullName ()
    {
        return $this->first_name . ' ' . $this->last_name;
    }

    /**
     * @param mixed $age
     */
    public function setAge ($age)
    {
        $this->age = $age;
    }

    /**
     * @return mixed
     */
    public function getAge ()
    {
        return $this->age;
    }

    /**
     * Handle created at date
     * @ORM\PrePersist()
     */
    public function handleCreatedAt ()
    {
        $date = new \DateTime ('now', new \DateTimeZone ('UTC'));
        $this->created_at = $date;
        $this->updated_at = $date;
    }

    /**
     * @return mixed
     */
    public function getCreatedAt ()
    {
        return $this->created_at;
    }

    /**
     * @param mixed $discount
     */
    public function setDiscount ($discount)
    {
        $this->discount = $discount;
    }

    /**
     * @return mixed
     */
    public function getDiscount ()
    {
        return $this->discount;
    }

    /**
     * @param mixed $email
     */
    public function setEmail ($email)
    {
        $this->email = $email;
    }

    /**
     * @return mixed
     */
    public function getEmail ()
    {
        return $this->email;
    }

    /**
     * @param mixed $gender
     */
    public function setGender ($gender)
    {
        $this->gender = $gender;
    }

    /**
     * @return mixed
     */
    public function getGender ()
    {
        return $this->gender;
    }

    /**
     * @param mixed $id
     */
    public function setId ($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getId ()
    {
        return $this->id;
    }

    /**
     * @param mixed $password
     */
    public function setPassword ($password)
    {
        $this->password = $password;
    }

    /**
     * @return mixed
     */
    public function getPassword ()
    {
        return $this->password;
    }

    /**
     * @param mixed $address1
     */
    public function setAddress1 ($address1)
    {
        $this->address1 = $address1;
    }

    /**
     * @return mixed
     */
    public function getAddress1 ()
    {
        return $this->address1;
    }

    /**
     * @param mixed $address2
     */
    public function setAddress2 ($address2)
    {
        $this->address2 = $address2;
    }

    /**
     * @return mixed
     */
    public function getAddress2 ()
    {
        return $this->address2;
    }

    /**
     * @param mixed $city
     */
    public function setCity ($city)
    {
        $this->city = $city;
    }

    /**
     * @return mixed
     */
    public function getCity ()
    {
        return $this->city;
    }

    /**
     * @param mixed $company
     */
    public function setCompany ($company)
    {
        $this->company = $company;
    }

    /**
     * @return mixed
     */
    public function getCompany ()
    {
        return $this->company;
    }

    /**
     * @param Country $country
     */
    public function attachCountry (Country $country = null)
    {
        $this->country = $country;
    }

    /**
     * @return Country
     */
    public function getCountry ()
    {
        return $this->country;
    }

    /**
     * @param mixed $first_name
     */
    public function setFirstName ($first_name)
    {
        $this->first_name = $first_name;
    }

    /**
     * @return mixed
     */
    public function getFirstName ()
    {
        return $this->first_name;
    }

    /**
     * @param mixed $last_name
     */
    public function setLastName ($last_name)
    {
        $this->last_name = $last_name;
    }

    /**
     * @return mixed
     */
    public function getLastName ()
    {
        return $this->last_name;
    }

    /**
     * @param mixed $post_code
     */
    public function setPostCode ($post_code)
    {
        $this->post_code = $post_code;
    }

    /**
     * @return mixed
     */
    public function getPostCode ()
    {
        return $this->post_code;
    }

    /**
     * @param State $state
     */
    public function attachState (State $state = null)
    {
        $this->state = $state;
    }

    /**
     * @return State
     */
    public function getState ()
    {
        return $this->state;
    }

    /**
     * @return boolean
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @param boolean $active
     */
    public function setActive($active)
    {
        $this->active = $active;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updated_at;
    }

    /**
     * Handle updated at date
     *
     * @ORM\PreUpdate()
     */
    public function handleUpdatedAt ()
    {
        $this->updated_at = new \DateTime ('now', new \DateTimeZone ('UTC'));
    }

    /**
     * @return mixed
     */
    public function getNewsletter ()
    {
        return $this->newsletter;
    }

    /**
     * @param mixed $newsletter
     */
    public function setNewsletter($newsletter)
    {
        $this->newsletter = $newsletter;
    }
    /**
     * @return mixed
     */
    public function getBtob ()
    {
        return $this->btob;
    }

    /**
     * @param mixed $btob
     */
    public function setBtob($btob)
    {
        $this->btob = $btob;
    }

    /**
     * @return mixed
     */
    public function getContactPhone()
    {
        return $this->contact_phone;
    }

    /**
     * @param mixed $contact_phone
     */
    public function setContactPhone($contact_phone)
    {
        $this->contact_phone = $contact_phone;
    }

    /**
     * @return mixed
     */
    public function getLoyaltyDiscount()
    {
        return $this->loyalty_discount;
    }

    /**
     * @param mixed $contact_phone
     */
    public function setLoyaltyDiscount($loyalty_discount)
    {
        $this->loyalty_discount = $loyalty_discount;
    }

    /**
     * @return mixed
     */
    public function getWishList()
    {
        return $this->wish_list;
    }

    /**
     * @param mixed $wish_list
     */
    public function setWishList($wish_list)
    {
        $this->wish_list = $wish_list;
    }
    /**
     * @return mixed
     */
    public function getCustomInformation()
    {
        return $this->custom_information;
    }

    /**
     * @param mixed $custom_information
     */
    public function setCustomInformation($custom_information)
    {
        $this->custom_information = $custom_information;
    }

    /**
     * @param $email
     * @param $password
     * @return string
     */
    public static function encrypt ($email, $password)
    {
        return hash ('sha512', base64_encode ($email . $password));
    }
}