<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Customer\Form;


use MotoStore\Customer\Entity\Customer;
use MotoStore\Platform\Form\Filter\DefaultValue;
use MotoStore\Platform\Form\FormTypeAbstract;

class CustomerType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array (
        );
    }

    /**
     * Build Form
     */
    public function init ()
    {
        $default = new DefaultValue (0);

        $this
            ->add (array (
                'name'      => 'active',
                'required'  => false,
                'filters'=> array (
                    $default
                ),
            ))
            ->add (array (
                'name'      => 'newsletter',
                'required'  => false,
                'filters'=> array (
                    $default
                ),
            ))
            ->add (array (
                'name'      => 'btob',
                'required'  => false,
                'filters'=> array (
                    $default
                ),
            ))
            ->add (array (
                'name'      => 'city',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'email',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'EmailAddress',
                        'options' => array (
                            'domain' => false
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'first_name',
                'required'  => true,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'last_name',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'company',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'address1',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'address2',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'custom_information',
                'required'  => false,
                'validators'=> array (
                ),
            ))
            ->add (array (
                'name'      => 'post_code',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 32,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'contact_phone',
                'required'  => false,
                'validators'=> array (
                    array(
                        'name' => 'Regex',
                        'options' => array(
                            'pattern' => '/\+?\d{5,20}/',
                        ),
                    )
                ),
            ))
        ->add (array (
        'name'      => 'loyalty_discount',
        'required'  => false,
        'validators'=> array (
            array(
                'name' => 'Digits',
            )
        ),
    ));
    }

    /**
     * @param $data
     * @param Customer $entity
     */
    protected function onPresetData (&$data, $entity)
    {
        $this->applyCountry ($data, $entity);
        $this->applyState ($data, $entity);
    }

    /**
     * @param $data
     * @param Customer $entity
     */
    public function applyCountry ($data, Customer $entity)
    {
        $country = null;

        if ($data ['country'] && !empty ($data ['country'] ['id']))
        {
            $country = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Localization\Entity\Country')
                ->find ($data ['country'] ['id']);
        }
        $entity->attachCountry ($country);
    }

    /**
     * @param $data
     * @param Customer $entity
     */
    public function applyState ($data, Customer $entity)
    {
        $state = null;

        if ($data ['state'] && !empty ($data ['state'] ['id']))
        {
            $state = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Localization\Entity\State')
                ->find ($data ['state'] ['id']);
        }
        $entity->attachState ($state);
    }
}