<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Localization\Collection;


use Doctrine\ORM\QueryBuilder;
use MotoStore\Collection\Collection;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class Country implements FactoryInterface
{
    /**
     * Create service
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService (ServiceLocatorInterface $serviceLocator)
    {
        $collection = new Collection ();

        /** @var QueryBuilder $queryBuilder */
        $queryBuilder = $serviceLocator
            ->get ('MotoStore\EntityManager')
            ->createQueryBuilder ();

        $query = $queryBuilder
            ->select (array ('c', 's'))
            ->from ('MotoStore\Localization\Entity\Country', 'c')
            ->leftJoin ('c.states', 's');

        $collection->setQuery ($query);

        $collection->setPropertiesMap (array (
            'iso_2'   => 'c.iso_2',
            'name'    => 'c.name',
        ));

        return $collection;
    }
}