<?php
/**
 * Created by PhpStorm.
 * User: olegk
 * Date: 2/8/15
 * Time: 12:18 AM
 */

namespace MotoStore\Localization\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class Country
 * @package MotoStore\Localization\Entity
 * @ORM\Entity(readOnly=true)
 * @ORM\Table(name="store_country",options={"engine":"InnoDB"})
 */
class Country
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @var string
     * @ORM\Column(type="string")
     */
    protected $name;

    /**
     * @var string
     * @ORM\Column(type="string", length=2)
     */
    protected $iso_2;

    /**
     * @var string
     * @ORM\Column(type="string", length=3)
     */
    protected $iso_3;

    /**
     * @var ArrayCollection[State]
     * @ORM\OneToMany(targetEntity="MotoStore\Localization\Entity\State", mappedBy="country")
     */
    protected $states;


    public function __construct ()
    {
        $this->states = new ArrayCollection ();
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return $this
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getIso2()
    {
        return $this->iso_2;
    }

    /**
     * @param string $iso_2
     * @return $this
     */
    public function setIso2($iso_2)
    {
        $this->iso_2 = $iso_2;

        return $this;
    }

    /**
     * @return string
     */
    public function getIso3()
    {
        return $this->iso_3;
    }

    /**
     * @param string $iso_3
     * @return $this
     */
    public function setIso3($iso_3)
    {
        $this->iso_3 = $iso_3;

        return $this;
    }

    /**
     * @return ArrayCollection[Sate]
     */
    public function getStates ()
    {
        return $this->states;
    }

    /**
     * @param State $state
     * @return $this
     */
    public function setState (State $state)
    {
        $this->states->add ($state);

        return $this;
    }

    /**
     * @return bool
     */
    public function hasState ()
    {
        return $this->getStates ()->count () > 0;
    }
}