<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Mailer;


use Doctrine\ORM\EntityManager;
use MotoStore\Mailer\Entity\Template;
use Zend\Mail\Message;
use Zend\Mail\Transport\TransportInterface;
use Zend\Mime\Part;

class Agent
{
    /**
     * @var TransportInterface
     */
    protected $adapter;

    /**
     * @var EntityManager
     */
    protected $entityManager;

    /**
     * @var \Twig_Environment
     */
    protected $renderer;

    /**
     * Send From
     *
     * @var string
     */
    protected $from;

    /**
     * @var string
     */
    protected $fromName;

    /**
     * @param TransportInterface $adapter
     */
    public function __construct (TransportInterface $adapter)
    {
        $this->adapter = $adapter;
    }

    /**
     * @return string
     */
    public function getFrom ()
    {
        return $this->from;
    }

    /**
     * @param string $from
     * @return $this
     */
    public function setFrom ($from)
    {
        $this->from = $from;

        return $this;
    }

    /**
     * @return string
     */
    public function getFromName()
    {
        return $this->fromName;
    }

    /**
     * @param string $fromName
     * @return $this
     */
    public function setFromName($fromName)
    {
        $this->fromName = $fromName;

        return $this;
    }

    /**
     * @return TransportInterface
     */
    public function getAdapter()
    {
        return $this->adapter;
    }

    /**
     * @return EntityManager
     */
    public function getEntityManager()
    {
        return $this->entityManager;
    }

    /**
     * @param EntityManager $entityManager
     * @return $this
     */
    public function setEntityManager($entityManager)
    {
        $this->entityManager = $entityManager;

        return $this;
    }

    /**
     * @return \Twig_Environment
     */
    public function getRenderer()
    {
        return $this->renderer;
    }

    /**
     * @param \Twig_Environment $renderer
     * @return $this
     */
    public function setRenderer($renderer)
    {
        $this->renderer = clone $renderer;

        $this
            ->renderer
            ->setLoader (new \Twig_Loader_String ());

        return $this;
    }

    /**
     * Sent Message
     *
     * @param $email
     * @param $name
     * @param $subject
     * @param $body
     * @param $forceutf8
     */
    public function send ($email, $name, $subject, $body, $forceutf8 = 0)
    {
        $message = new Message ();
        $message->setEncoding('UTF-8');

        $message
            ->setFrom($this->getFrom(), $this->getFromName())
            ->addTo($email, $name)
            ->setSubject($subject);

        $html = new Part ($body);
        $html->type = "text/html";
        if ($forceutf8)
        {
            $html->charset = 'UTF-8';
        }

        $body = new \Zend\Mime\Message ();
        $body->addPart($html);

        $message->setBody($body);


        if ($message->isValid ())
        {
            try
            {

                foreach(array('Subject', 'From', 'To') as $_h){
                    $message->getHeaders()->get($_h)->setEncoding('UTF-8');
                }

                $this
                    ->getAdapter ()
                    ->send ($message);
            }
            catch (\Exception $e)
            {
                error_log ('Store mail agent exception: ' . $e->getMessage ());
            }
        }
        else
        {
            error_log ('Store mail agent error [invalid email]: Field From value is empty');
        }
    }


    /**
     * @param array $recipient
     * @param $target
     * @param array $variables
     * @param string $title
     */
    public function sendTemplate ($recipient = array (), $target, $variables = array (), $title = false)
    {
        /**
         * @var Template $template
         */
        $template = $this
            ->getEntityManager ()
            ->getRepository ('MotoStore\Mailer\Entity\Template')
            ->findOneBy (array ('target' => $target));

        if ($template->getActive ()){
            foreach ($recipient as $email => $name)
            {
                $body = $this
                    ->getRenderer ()
                    ->render ($template->getTemplate (), $variables);
                $subject = $template->getName ();
                if ($title){
                    $subject = $title;
                }
                $this->send ($email, $name, $subject, $body, $template->getForceutf8());
            }
        }

    }

}
