<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Mailer\Factory;


use MotoStore\Mailer\Agent;
use Zend\Mail\Transport\Sendmail;
use Zend\Mail\Transport\Smtp;
use Zend\Mail\Transport\SmtpOptions;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class MailService implements FactoryInterface
{
    /**
     * @var \ArrayObject
     */
    protected $options = array();

    const AUTHENTICATION_BASE   = 'base';
    const AUTHENTICATION_PLAIN  = 'plain';
    const AUTHENTICATION_LOGIN  = 'login';
    const AUTHENTICATION_TLS    = 'tls';

    const AGENT_SENDMAIL        = 'tls';
    const AGENT_SMTP            = 'smtp';

    const TLS_PORT              = 587;

    /**
     * Create service
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        $options = $this
            ->initOptions ($serviceLocator);

        if ($options->offsetGet ('transport') == self::AGENT_SMTP)
        {
            $transport =  $this->createSMTPTransport ($options);
        }
        else
        {
            $transport =  $this->createSendmailTransport ($options);
        }

        $agent = new Agent ($transport);
        $agent
            ->setFrom ($options->offsetGet ('mail_from'))
            ->setFromName ($options->offsetGet ('mail_name'))
            ->setEntityManager ($serviceLocator->get ('MotoStore\EntityManager'))
            ->setRenderer ($serviceLocator->get ('store.twig'));




        return $agent;
    }

    /**
     * @param \ArrayObject $options
     * @return Agent
     */
    protected function createSendmailTransport (\ArrayObject $options)
    {
        return new Sendmail ();
    }

    /**
     * Create SMTP Agent
     *
     * @param $mailOptions
     * @return Smtp
     */
    protected function createSMTPTransport (\ArrayObject $mailOptions)
    {
        $options = new SmtpOptions ();

        if (
            $mailOptions->offsetExists ('smtp_host') &&
            $mailOptions->offsetExists ('smtp_port')
        )
        {
            $options
                ->setName($mailOptions->offsetGet('smtp_host'))
                ->setHost($mailOptions->offsetGet('smtp_host'))
                ->setPort($mailOptions->offsetGet('smtp_port'));

        }

        $config = array (
            'username' => $mailOptions->offsetExists ('smtp_username') ? $mailOptions->offsetGet ('smtp_username'): '',
            'password' => $mailOptions->offsetGet ('smtp_password') ? $mailOptions->offsetGet ('smtp_password') : '',
        );

        switch ($mailOptions->offsetGet ('smtp_authentication'))
        {
            case self::AUTHENTICATION_LOGIN:
                $options
                    ->setConnectionClass (self::AUTHENTICATION_LOGIN);
                break;
            case self::AUTHENTICATION_TLS:
                $options
                    ->setConnectionClass (self::AUTHENTICATION_PLAIN)
                    ->setPort (self::TLS_PORT);
                $config ['ssl'] = self::AUTHENTICATION_TLS;
                break;
            default:
                $options
                    ->setConnectionClass (self::AUTHENTICATION_PLAIN);
                break;
        }

        $options->setConnectionConfig ($config);

        return new Smtp ($options);
    }


    /**
     * Mail Options
     *
     * @param ServiceLocatorInterface $sm
     * @return array|\ArrayObject
     */
    protected function initOptions(ServiceLocatorInterface $sm)
    {
        if (!$this->options)
        {
            $this->options = new \ArrayObject (
                $sm
                    ->get('MotoStore\EntityManager')
                    ->getRepository('MotoStore\Settings\Entity\Option')
                    ->getModuleOptions('storesettings_mail')
            );
        }
        return $this->options;
    }


}
