<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Order\Cart;


use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Product\Entity\Product;
use MotoStore\Product\Entity\Variant;
use Zend\EventManager\EventManager;
use Zend\Session\Container;

class Storage
{
    const STORAGE_NAMESPACE = 'cart';
    /**
     * @var Container
     */
    protected $storage;

    public function __construct ()
    {
        $this->storage = new Container (self::STORAGE_NAMESPACE);
    }

    /**
     * @return Container
     */
    public function getStorage()
    {
        return $this->storage;
    }
    
    /**
     * Clear Session Cart
     */
    public function clear ()
    {
        $this
            ->storage
            ->getManager ()
            ->destroy ();
    }

    /**
     * Add cart Item
     *
     * @param $product
     * @param int $quantity
     * @param int $variant_id
     */
    public function addItem (Product $product, $quantity = 1, $variant_id = 0, $custom_options = array())
    {
        $items        = $this->getItems ();
        $id           = sprintf('%d_%d', $product->getId (), $variant_id);

        $items [$id] = array(
            'id'            => $id,
            'product_id'    => $product,
            'quantity'      => $quantity,
            'variant_id'    => $variant_id,
            'custom_options'=> $custom_options,
        );

        $this
            ->storage
            ->offsetSet ('products', $items);

        $this
            ->getEventManager ()
            ->trigger ('store.event.cart.add', null, $items);
    }


    /**
     * Update cart Item
     *
     * @param $id
     * @param int $quantity
     */
    public function updateItem ($id, $quantity = 1)
    {
        $items = $this->getItems ();

        if (array_key_exists ($id, $items))
        {
            $items [$id] ['quantity'] = $quantity;

            $this
                ->storage
                ->offsetSet ('products', $items);

            $this
                ->getEventManager ()
                ->trigger ('store.event.cart.update', null, $items);
        }
    }


    public function setShippingMethod ($shipping_method)
    {
            $this
                ->storage
                ->offsetSet ('shipping_method', $shipping_method);


    }

    public function getShippingMethod ()
    {

        if ($this->storage->offsetExists ('shipping_method'))
        {
            return $this->storage->offsetGet('shipping_method');
        }
        return 0;
    }


    /**
     * Items
     * @return array
     */
    public function getItems ()
    {

        if ($this->storage->offsetExists ('products'))
        {
            return $this->storage->offsetGet('products');
        }
        return array ();
    }

    /**
     * Remove Item From Cart
     *
     * @param $product_id
     */
    public function removeItem ($product_id)
    {
        $items = $this->getItems ();

        if (array_key_exists ($product_id, $items))
        {
            unset ($items [$product_id]);

            $this
                ->storage
                ->offsetSet ('products', $items);

            $this
                ->getEventManager ()
                ->trigger ('store.event.cart.remove', null, $items);
        }
    }

    /**
     * Set order comment
     *
     * @param $comment
     */
    public function setComment ($comment)
    {
        $this->storage->offsetSet ('comment', $comment);
    }

    /**
     * Get order comment
     * @return mixed|string
     */
    public function getComment ()
    {
        if ($this->storage->offsetExists ('comment'))
        {
            return $this->storage->offsetGet ('comment') ;
        }

        return '';
    }

    /**
     * @param array $discount
     */
    public function setDiscount ($discount)
    {
        if ($discount)
        {
            $this
                ->storage
                ->offsetSet ('discount', $discount);
        }
    }

    public function getDiscount ()
    {
        if ($this->storage->offsetExists ('discount'))
        {
            return $this->storage->offsetGet ('discount') ;
        }

        return array ();
    }


    public function addCompareItem (Product $product)
    {
        $items        = $this->getCompareItems ();
        $id           = $product->getId ();
        if (!isset($items[$id]) && count($items) > 2){
            array_shift($items);
        }

        $items [$id] = array(
            'id'            => $id,
            'product_id'    => $product,
        );

        $this
            ->storage
            ->offsetSet ('compare', $items);

        $this
            ->getEventManager ()
            ->trigger ('store.event.cart.updatecompare', null, $items);
    }


    public function removeCompareItem ($product_id)
    {
        $items = $this->getCompareItems ();
        foreach ( $items as $k=>$item){
            if ($item['id'] == $product_id){
                unset ($items [$k]);
            }
        }



            $this
                ->storage
                ->offsetSet ('compare', $items);

            $this
                ->getEventManager ()
                ->trigger ('store.event.cart.updatecompare', null, $items);

    }


    public function getCompareItems ()
    {
        if ($this->storage->offsetExists ('compare'))
        {
            return $this->storage->offsetGet ('compare') ;
        }

        return array ();
    }

    /**
     * @param $step
     * @param bool $valid
     * @return mixed
     */
    public function setValidStep ($step, $valid = true)
    {
        $steps = array ();

        if ($this->storage->offsetExists ('valid_steps'))
        {
            $steps = $this->storage->offsetGet ('steps') ;
        }

        $steps [$step] = $valid;

        $this
            ->storage
            ->offsetSet ('valid_steps', $steps);
    }


    public function getValidSteps ()
    {
        if ($this->storage->offsetExists ('valid_steps'))
        {
            return $this->storage->offsetGet ('valid_steps') ;
        }
        return array ();
    }

    public function clearOrderData ()
    {
        $this
            ->storage
            ->offsetUnset ('valid_steps');
        $this
            ->storage
            ->offsetUnset ('discount');

        $this
            ->storage
            ->offsetUnset ('products');

        $this
            ->storage
            ->offsetUnset ('shipping');

        $this
            ->storage
            ->offsetUnset ('create_account');

        $this
            ->storage
            ->offsetUnset ('comment');
    }


    /**
     * @param array $shipping
     */
    public function setShippingDetails ($shipping)
    {
        if ($shipping)
        {
            $this
                ->storage
                ->offsetSet ('shipping', $shipping);
        }
    }

    /**
     * Get Shipping Address Details
     *
     * @return array|mixed
     */
    public function getShippingDetails ()
    {
        if ($this->storage->offsetExists ('shipping'))
        {
            return $this
                ->storage
                ->offsetGet ('shipping') ;
        }

        return array ();
    }

    /**
     * @param array $shipping
     */
    public function setShippingAddress ($shipping)
    {
        if ($shipping)
        {
            $this
                ->storage
                ->offsetSet ('shipping_address', $shipping);
        }
    }

    /**
     * Get Shipping Address Details
     *
     * @return array|mixed
     */
    public function getShippingAddress ()
    {
        if ($this->storage->offsetExists ('shipping_address'))
        {
            return $this
                ->storage
                ->offsetGet ('shipping_address') ;
        }

        return array ();
    }

    /**
     * @param array $delivery_date
     */
    public function setDeliveryDate ($delivery_date)
    {
        if ($delivery_date)
        {
            $this
                ->storage
                ->offsetSet ('delivery_date', $delivery_date);
        }
    }

    /**
     * Get Delivery Date
     *
     * @return array|mixed
     */
    public function getDeliveryDate ()
    {
        if ($this->storage->offsetExists ('delivery_date'))
        {
            return $this
                ->storage
                ->offsetGet ('delivery_date') ;
        }

        return array ();
    }
    /**
     * @param array $shipping_name
     */
    public function setShippingName ($shipping_name)
    {
        if ($shipping_name)
        {
            $this
                ->storage
                ->offsetSet ('shipping_name', $shipping_name);
        }
    }

    /**
     * Get Shipping Name
     *
     * @return array|mixed
     */
    public function getShippingName ()
    {
        if ($this->storage->offsetExists ('shipping_name'))
        {
            return $this
                ->storage
                ->offsetGet ('shipping_name') ;
        }

        return array ();
    }

    public function setLastOrderId ($id)
    {
        if ($id)
        {
            $this
                ->storage
                ->offsetSet ('order_id', $id);
        }
    }


    /**
     * @return mixed|null
     */
    public function getLastOrderId ()
    {
        if ($this->storage->offsetExists ('order_id'))
        {
            return $this->storage->offsetGet ('order_id') ;
        }

        return null;
    }

    /**
     * @param $email
     */
    public function setConfirmationEmail ($email)
    {
        if ($email)
        {
            $this
                ->storage
                ->offsetSet ('confirmation_email', $email);
        }
    }

    /**
     * @return mixed|null
     */
    public function getConfirmationEmail ()
    {
        if ($this->storage->offsetExists ('confirmation_email'))
        {
            return $this->storage->offsetGet ('confirmation_email') ;
        }

        return null;
    }

    /**
     * @param $email
     */
    public function setIsSuccess ($is_success)
    {
        $this
            ->storage
            ->offsetSet ('is_order_success', $is_success);
    }

    /**
     * @return mixed|null
     */
    public function isSuccess ()
    {
        if ($this->storage->offsetExists ('is_order_success'))
        {
            return $this->storage->offsetGet ('is_order_success') ;
        }

        return null;
    }

    public function setTotalTax ($tax)
    {
        $this
            ->storage
            ->offsetSet ('total_tax', $tax);
    }


    /**
     * @return float|mixed
     */
    public function getTotalTax ()
    {
        if ($this->storage->offsetExists ('total_tax'))
        {
            return $this->storage->offsetGet ('total_tax') ;
        }

        return 0.00;
    }

    public function setCurrency ($currency_id)
    {
        $this
            ->storage
            ->offsetSet ('currency_id', $currency_id);
    }

    /**
     * @return mixed|null
     */
    public function getCurrency ()
    {
        if ($this->storage->offsetExists ('currency_id'))
        {
            return $this->storage->offsetGet ('currency_id') ;
        }

        return null;
    }
    public function setOrderBy ($orderby)
    {
        $this
            ->storage
            ->offsetSet ('order_by', $orderby);
    }

    /**
     * @return mixed|null
     */
    public function getOrderBy ()
    {
        if ($this->storage->offsetExists ('order_by'))
        {
            return $this->storage->offsetGet ('order_by') ;
        }

        return null;
    }
    public function setLimit ($limit,$is_category = false)
    {
        if ($is_category){
            $this
                ->storage
                ->offsetSet ('limit_category', $limit);
        } else {
            $this
                ->storage
                ->offsetSet ('limit', $limit);
        }

    }

    /**
     * @return mixed|null
     */
    public function getLimit ($is_category = false)
    {
        if ($is_category == false){
            if ($this->storage->offsetExists ('limit'))
            {
                return $this->storage->offsetGet ('limit') ;
            }

        } else {

            if ($this->storage->offsetExists ('limit_category'))
            {
                return $this->storage->offsetGet ('limit_category') ;
            }

        }
        return null;
    }

    public function setFilters ($filters, $cat_id)
    {
        $this
            ->storage
            ->offsetSet ('filters_' . $cat_id , $filters);
    }

    /**
     * @return mixed|null
     */
    public function getFilters ($cat_id)
    {
        if ($this->storage->offsetExists ('filters_' . $cat_id))
        {
            return $this->storage->offsetGet ('filters_' . $cat_id) ;
        }

        return null;
    }

    /**
     * @param $create
     */
    public function setCreateNewAccount ($create)
    {
        $this
            ->storage
            ->offsetSet ('create_account', $create);
    }

    /**
     * @return int|mixed
     */
    public function getCreateNewAccount ()
    {
        if ($this->storage->offsetExists ('create_account'))
        {
            return $this->storage->offsetGet ('create_account') ;
        }
        return 0;
    }

    /**
     * @param $disable
     */
    public function setDisableManualPayment ($disable)
    {
        $this
            ->storage
            ->offsetSet ('disable_manual_payment', $disable);
    }

    /**
     * @return int|mixed
     */
    public function getDisableManualPayment ()
    {
        if ($this->storage->offsetExists ('disable_manual_payment'))
        {
            return $this->storage->offsetGet ('disable_manual_payment') ;
        }
        return 0;
    }
    /**
     * @return EventManager
     */
    private function getEventManager ()
    {
        return SMStatic::getInstance ()->get ('store.eventmanager');
    }
}