<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Order\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use MotoStore\Localization\Entity\Country;
use MotoStore\Localization\Entity\State;


/**
 * Class Order
 * @package MotoStore\Order\Entity
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks()
 * @ORM\Table(name="`store_order`",options={"engine":"InnoDB"})
 */
class Order
{
    const ORDER_STATUS_PENDING      = 1;

    const ORDER_WAITING_PAYMENT     = 2;

    const ORDER_STATUS_PROCESSING   = 3;

    const ORDER_STATUS_SHIPPED      = 4;

    const ORDER_PAYMENT_ACCEPTED    = 5;

    const ORDER_STATUS_ON_HOLD      = 6;

    const ORDER_STATUS_CANCELED     = 7;

    const ORDER_STATUS_COMPLETE     = 8;

    const ORDER_STATUS_AWAITING_FULFILLMENT = 9;

     /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @ORM\Column(type="string")
     */
    protected $order_id;

    /** @ORM\Column(type="integer", nullable=true) */
    protected $customer_id;

    /** @ORM\Column(type="integer") */
    protected $status;

    /** @ORM\Column(type="datetime") */
    protected $created_at;

    /** @ORM\Column(type="datetime") */
    protected $updated_at;

    /**
     * @ORM\Column(type="string")
     */
    protected $first_name;

    /**
     * @ORM\Column(type="string", nullable=true)
     */
    protected $last_name;

    /**
     * @ORM\Column(type="string")
     */
    protected $email;

    /**
     * @ORM\Column(type="string", nullable=true)
     */
    protected $company;

    /**
     * @ORM\Column(type="string", nullable=true)
     */
    protected $address1;

    /**
     * @ORM\Column(type="string",  nullable=true)
     */
    protected $address2;

    /**
     * @ORM\Column(type="string", nullable=true)
     */
    protected $post_code;

    /**
     * @ORM\Column(type="string", nullable=true)
     */
    protected $city;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Localization\Entity\Country")
     * @ORM\JoinColumn(name="country_id", referencedColumnName="id", onDelete="SET NULL")
     */
    protected $country;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Localization\Entity\State")
     * @ORM\JoinColumn(name="state_id", referencedColumnName="id", onDelete="SET NULL")
     */
    protected $state;

    /**
     * @ORM\Column(type="string" , nullable=true)
     */
    protected $contact_phone;

    /** @ORM\Column(type="decimal", precision=10, scale=2) */
    protected $subtotal_price;

    /** @ORM\Column(type="decimal", precision=10, scale=2) */
    protected $shipping_price;

    /** @ORM\Column(type="decimal", precision=10, scale=2) */
    protected $tax_price;

    /** @ORM\Column(type="decimal", precision=10, scale=2) */
    protected $discount;

    /** @ORM\Column(type="decimal", precision=10, scale=2, nullable=true) */
    protected $discount_shipping;

    /** @ORM\Column(type="decimal", precision=10, scale=2) */
    protected $total_price;

    /** @ORM\Column(type="decimal", precision=10, scale=2) */
    protected $total_weight;

    /** @ORM\Column(type="decimal", precision=10, scale=2) */
    protected $total_length;

    /** @ORM\Column(type="decimal", precision=10, scale=2) */
    protected $total_width;

    /** @ORM\Column(type="decimal", precision=10, scale=2) */
    protected $total_depth;

    /** @ORM\Column(type="string", nullable=true) */
    protected $discount_code;

    /**
     * Public comment available for customer
     *
     * @ORM\Column(type="string", nullable=true)
     */
    protected $comment;

    /** @ORM\Column(type="text", nullable=true) */
    protected $shipping_adress;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    protected $payment_gateway;
    /**
     * @ORM\Column(type="text", nullable=true)
     */
    protected $shipping_name;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    protected $delivery_date;

    /**
     *
     * @ORM\OneToMany(targetEntity="MotoStore\Order\Entity\Product", mappedBy="order", cascade={"persist", "remove"})
     * @var \Doctrine\Common\Collections\ArrayCollection
     */
    protected $products;

    /**
     * @ORM\OneToMany(targetEntity="MotoStore\Order\Entity\Comment", mappedBy="order", cascade={"persist", "remove"})
     * @var \Doctrine\Common\Collections\ArrayCollection
     */
    protected $comments;

    /**
     * @ORM\OneToMany(targetEntity="MotoStore\Order\Entity\Transaction", mappedBy="order", cascade={"persist", "remove"})
     * @var \Doctrine\Common\Collections\ArrayCollection
     */
    protected $transactions;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Customer\Entity\Customer", inversedBy="orders")
     * @ORM\JoinColumn(name="customer_id", referencedColumnName="id", onDelete="SET NULL")
     */
    protected $customer;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Settings\Entity\Currency")
     * @ORM\JoinColumn(name="currency_id", referencedColumnName="id", onDelete="SET NULL")
     */
    protected $currency;


    public function __construct ()
    {
        $this->products = new ArrayCollection ();
        $this->comments = new ArrayCollection ();
        $this->transactions = new ArrayCollection ();
    }

    /**
     * Get all allowed order statuses;
     * @return array
     */
    public static function getOrderStatuses ()
    {
        return array (
            self::ORDER_STATUS_PENDING                  => 'STORE.ORDER.ORDER_STATUS_PENDING',
            self::ORDER_WAITING_PAYMENT                 => 'STORE.ORDER.ORDER_WAITING_PAYMENT',
            self::ORDER_STATUS_PROCESSING               => 'STORE.ORDER.ORDER_STATUS_PROCESSING',
            self::ORDER_STATUS_SHIPPED                  => 'STORE.ORDER.ORDER_STATUS_SHIPPED',
            self::ORDER_PAYMENT_ACCEPTED                => 'STORE.ORDER.ORDER_PAYMENT_ACCEPTED',
            self::ORDER_STATUS_ON_HOLD                  => 'STORE.ORDER.ORDER_STATUS_ON_HOLD',
            self::ORDER_STATUS_CANCELED                 => 'STORE.ORDER.ORDER_STATUS_CANCELED',
            self::ORDER_STATUS_COMPLETE                 => 'STORE.ORDER.ORDER_STATUS_COMPLETE',
            self::ORDER_STATUS_AWAITING_FULFILLMENT     => 'STORE.ORDER.ORDER_STATUS_AWAITING_FULFILLMENT',
        );
    }

    /**
     * @param string $prefix
     */
    public function createUniqueId ($prefix = '')
    {
        $this->setOrderId (uniqid ($prefix));
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getOrderId()
    {
        return $this->order_id;
    }

    /**
     * @param mixed $order_id
     */
    public function setOrderId($order_id)
    {
        $this->order_id = $order_id;
    }

    /**
     * @return mixed
     */
    public function getCustomerId()
    {
        return $this->customer_id;
    }

    /**
     * @param mixed $customer_id
     */
    public function setCustomerId($customer_id)
    {
        $this->customer_id = $customer_id;
    }

    /**
     * @return mixed
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param mixed $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     * @return mixed
     */
    public function getCreatedAt()
    {
        return $this->created_at;
    }

    /**
     * Handle created at date
     * @ORM\PrePersist()
     */
    public function handleCreatedAt ()
    {
        $date = new \DateTime ('now', new \DateTimeZone ('UTC'));
        $this->created_at = $date;
        $this->updated_at = $date;
    }

    /**
     * @return mixed
     */
    public function getUpdatedAt()
    {
        return $this->updated_at;
    }

    /**
     * Handle updated at date
     *
     * @ORM\PreUpdate()
     */
    public function handleUpdatedAt ()
    {
        $this->updated_at = new \DateTime ('now', new \DateTimeZone ('UTC'));
    }

    /**
     * @return mixed
     */
    public function getFirstName()
    {
        return $this->first_name;
    }

    /**
     * @param mixed $first_name
     */
    public function setFirstName($first_name)
    {
        $this->first_name = $first_name;
    }

    /**
     * @return mixed
     */
    public function getLastName()
    {
        return $this->last_name;
    }

    /**
     * @param mixed $last_name
     */
    public function setLastName($last_name)
    {
        $this->last_name = $last_name;
    }

    /**
     * @return mixed
     */
    public function getEmail()
    {
        return $this->email;
    }

    public function getFullName ()
    {
        return $this->first_name . ' ' . $this->last_name;
    }

    /**
     * @param mixed $email
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }

    /**
     * @return mixed
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * @param mixed $company
     */
    public function setCompany($company)
    {
        $this->company = $company;
    }

    /**
     * @return mixed
     */
    public function getAddress1()
    {
        return $this->address1;
    }

    /**
     * @param mixed $address1
     */
    public function setAddress1($address1)
    {
        $this->address1 = $address1;
    }

    /**
     * @return mixed
     */
    public function getAddress2()
    {
        return $this->address2;
    }

    /**
     * @param mixed $address2
     */
    public function setAddress2($address2)
    {
        $this->address2 = $address2;
    }

    /**
     * @return mixed
     */
    public function getPostCode()
    {
        return $this->post_code;
    }

    /**
     * @param mixed $post_code
     */
    public function setPostCode($post_code)
    {
        $this->post_code = $post_code;
    }

    /**
     * @return mixed
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @param mixed $city
     */
    public function setCity($city)
    {
        $this->city = $city;
    }

    /**
     * @return Country
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @param mixed $currency
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
    }
    /**
     * @return Country
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param mixed $country
     */
    public function addCountry($country)
    {
        $this->country = $country;
    }

    /**
     * @return State
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * @param mixed $state
     */
    public function addState($state)
    {
        $this->state = $state;
    }

    /**
     * @return mixed
     */
    public function getContactPhone()
    {
        return $this->contact_phone;
    }

    /**
     * @param mixed $contact_phone
     */
    public function setContactPhone($contact_phone)
    {
        $this->contact_phone = $contact_phone;
    }

    /**
     * @return mixed
     */
    public function getSubtotalPrice()
    {
        return $this->subtotal_price;
    }

    /**
     * @param mixed $subtotal_price
     */
    public function setSubtotalPrice($subtotal_price)
    {
        $this->subtotal_price = $subtotal_price;
    }

    /**
     * @return mixed
     */
    public function getShippingPrice()
    {
        return $this->shipping_price;
    }

    /**
     * @param mixed $shipping_price
     */
    public function setShippingPrice($shipping_price)
    {
        $this->shipping_price = $shipping_price;
    }

    /**
     * @return mixed
     */
    public function getTaxPrice()
    {
        return $this->tax_price;
    }

    /**
     * @param mixed $tax_price
     */
    public function setTaxPrice($tax_price)
    {
        $this->tax_price = $tax_price;
    }

    /**
     * @return mixed
     */
    public function getDiscount()
    {
        return $this->discount;
    }

    /**
     * @param mixed $discount
     */
    public function setDiscount($discount)
    {
        $this->discount = $discount;
    }
    /**
     * @return mixed
     */
    public function getDiscountShipping()
    {
        return $this->discount_shipping;
    }

    /**
     * @param mixed $discount
     */
    public function setDiscountShipping($discount)
    {
        $this->discount_shipping = $discount;
    }

    /**
     * @return mixed
     */
    public function getTotalPrice()
    {
        return $this->total_price;
    }

    /**
     * @param mixed $total_price
     */
    public function setTotalPrice($total_price)
    {
        $this->total_price = $total_price;
    }

    /**
     * @return mixed
     */
    public function getTotalWeight()
    {
        return $this->total_weight;
    }

    /**
     * @param mixed $total_weight
     */
    public function setTotalWeight($total_weight)
    {
        $this->total_weight = $total_weight;
    }

    /**
     * @return mixed
     */
    public function getTotalLength()
    {
        return $this->total_length;
    }

    /**
     * @param mixed $total_length
     */
    public function setTotalLength($total_length)
    {
        $this->total_length = $total_length;
    }

    /**
     * @return mixed
     */
    public function getTotalWidth()
    {
        return $this->total_width;
    }

    /**
     * @param mixed $total_width
     */
    public function setTotalWidth($total_width)
    {
        $this->total_width = $total_width;
    }

    /**
     * @return mixed
     */
    public function getTotalDepth()
    {
        return $this->total_depth;
    }

    /**
     * @param mixed $total_depth
     */
    public function setTotalDepth($total_depth)
    {
        $this->total_depth = $total_depth;
    }

    /**
     * @return mixed
     */
    public function getDiscountCode()
    {
        return $this->discount_code;
    }

    /**
     * @param mixed $discount_code
     */
    public function setDiscountCode($discount_code)
    {
        $this->discount_code = $discount_code;
    }

    /**
     * @return ArrayCollection
     */
    public function getProducts()
    {
        return $this->products;
    }

    /**
     * @param ArrayCollection $products
     */
    public function addProducts ($products)
    {
        $this->products = $products;
    }

    /**
     * @return ArrayCollection
     */
    public function getComments()
    {
        return $this->comments;
    }

    /**
     * @param ArrayCollection $comments
     */
    public function addComments($comments)
    {
        $this->comments = $comments;
    }

    /**
     * @return mixed
     */
    public function getCustomer()
    {
        return $this->customer;
    }

    /**
     * @param mixed $customer
     */
    public function addCustomer($customer)
    {
        $this->customer = $customer;
    }

    /**
     * @return mixed
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param mixed $comment
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
    }

    /**
     * Get Order Status name by ID
     * * @param null $status_id
     * @return string
     */
    public static function getStatusName ($status_id)
    {
        $statuses   = self::getOrderStatuses ();


        if (array_key_exists ($status_id, $statuses))
        {
            return $statuses [$status_id];
        }

        return '';
    }

    public function getStatusText ()
    {
        return $this->getStatusName ($this->getStatus ());
    }

    /**
     * @return ArrayCollection
     */
    public function getTransactions()
    {
        return $this->transactions;
    }

    /**
     * @param $transactions
     */
    public function addTransaction ($transactions)
    {
        $this->transactions->add ($transactions);
    }

    /**
     * @return mixed
     */
    public function getShippingAddress()
    {
        return $this->shipping_adress;
    }

    /**
     * @param mixed $address
     */
    public function setShippingAddress($address)
    {
        $this->shipping_adress = $address;
    }
    /**
     * @return mixed
     */
    public function getPaymentGateway()
    {
        return $this->payment_gateway;
    }

    /**
     * @param mixed $payment_gateway
     */
    public function setPaymentGateway($payment_gateway)
    {
        $this->payment_gateway = $payment_gateway;
    }
    /**
     * @return mixed
     */
    public function geShippingName()
    {
        return $this->shipping_name;
    }

    /**
     * @param mixed $shipping_name
     */
    public function setShippingName($shipping_name)
    {
        $this->shipping_name = $shipping_name;
    }
    /**
     * @return mixed
     */
    public function getDeliveryDate()
    {
        return $this->delivery_date;
    }

    /**
     * @param mixed $delivery_date
     */
    public function setDeliveryDate($delivery_date)
    {
        $this->delivery_date = $delivery_date;
    }

}