<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Order\Form;


use MotoStore\Order\Entity\Comment;
use MotoStore\Order\Entity\Order;
use MotoStore\Platform\Form\FormTypeAbstract;


class CommentType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies()
    {
        return array ();
    }

    public function init ()
    {
        $this
            ->add (array (
                'name'      => 'comment',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 0,
                            'max' => 255,
                        )
                    )

                ),
            ))
            ->add (array (
                'name'      => 'order_id',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'Digits',
                    )
                ),
            ))
            ->add (array (
                'name'      => 'status',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'Digits',
                    )
                ),
            ));
    }

    /**
     * Apply order data
     *
     * @param $data
     * @param Comment $entity
     */
    protected function onPresetData(&$data, Comment $entity)
    {
        if (!empty ($data ['order_id']))
        {
            /**
             * @var Order $order
             */
            $order = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Order\Entity\Order')
                ->find ($data ['order_id']);

            if ($order)
            {
                $order->setStatus ($data ['status']);
                $entity->setOrder ($order);
                $this
                    ->getEntityManager ()->merge ($order);
            }
        }
    }
}