<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Payment\Gateway;


use MotoStore\Order\Entity\Order;

interface PaymentGatewayInterface
{
    /**
     * Get payment processor
     *
     * @return string
     */
    public function getName ();

    /**
     * Get Payment Icon
     * @return string
     */
    public function getImage ();

    /**
     * description
     * @return string
     */
    public function getDescription ();

    /**
     * Help text
     * @return string
     */
    public function getHelpText ();


    /**
     * Payment Variables Array
     * @return array
     */
    public function getVariables ();

    /**
     * Set Payment Variables Array
     * @return array
     */
    public function setVariables ();

    /**
     * @param Order $order
     * @return mixed
     */
    public function checkout (Order $order);
}