<?php
namespace MotoStore\Payment\Gateway;


use Zend\ServiceManager\ServiceLocatorInterface;

class Provider
{
    /**
     * @var ServiceLocatorInterface
     */
    protected $serviceLocator;

    /**
     * @param ServiceLocatorInterface $serviceLocator
     */
    public function __construct (ServiceLocatorInterface $serviceLocator)
    {
        $this->serviceLocator = $serviceLocator;
    }

    /**
     * @param $providerName
     * @return PaymentModule
     */
    public function getPaymentMethod ($providerName)
    {
        $config = $this
            ->serviceLocator
            ->get ('store.config');

        $paymentsConfig = $config ['Payments'];
        $paymentsConfig = \Moto\Hook::trigger("MOTOSTORE_HOOK_PAYMENTS_CONFIG",$paymentsConfig);
        if (array_key_exists ($providerName, $paymentsConfig))
        {
            $provider = $paymentsConfig [$providerName];

            return new $provider ($this->serviceLocator);
        }
        return null;
    }

    /**
     * @return array [PaymentModule]
     */
    public function getPaymentMethods ()
    {
        $config = $this
            ->serviceLocator
            ->get ('store.config');
        $paymentsConfig = $config ['Payments'];
        $paymentsConfig = \Moto\Hook::trigger("MOTOSTORE_HOOK_PAYMENTS_CONFIG",$paymentsConfig);
        $serviceLocator = $this->serviceLocator;

        return array_map (function ($class) use ($serviceLocator)  {

            return new $class ($serviceLocator);

        }, $paymentsConfig);
    }
}