<?php


namespace MotoStore\Payment\LiqPay;

use MotoStore\Content\Helper\Link;
use MotoStore\Order\Entity\Order;
use MotoStore\Order\Entity\Product;
use MotoStore\Order\Entity\Transaction;
use MotoStore\Payment\Gateway\PaymentModule;
use Zend\Http\Client;
use Zend\Http\PhpEnvironment\Request;
use Zend\Uri\UriFactory;

class LiqPay extends PaymentModule
{

    private $_apiUrl = 'https://www.liqpay.ua/api/3/checkout/';
    /**
     * Get payment processor
     *
     * @return string
     */
    public function getName()
    {
        return 'LiqPay';
    }

    /**
     * Get Payment Icon
     * @return string
     */
    public function getImage ()
    {
        return 'logo-liqpay.png';
    }

    /**
     * description
     * @return string
     */
    public function getDescription ()
    {
        return '';
    }

    /**
     * Help text
     * @return string
     */
    public function getHelpText()
    {
        return "Available currencies : EUR,UAH,USD,RUB,RUR<br/>
                Available languages : en, ru";
    }

    public function setVariables ()
    {
        $this
            ->addVariable (
                self::OPTION_DISPLAY_NAME,
                array(
                    'name' => 'Display Name',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => '',
                    'default' => 'LiqPay',
                    'required' => true,
                )
            )
            ->addVariable (
                'public_key',
                array(
                    'name' => 'Public key LiqPay',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => '',
                    'default' => '',
                    'required' => true,
                )
            )
            ->addVariable (
                'private_key',
                array(
                    'name' => 'Private key LiqPay',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => '',
                    'default' => '',
                    'required' => true,
                )
            )
            ->addVariable (
                'sendbox',
                array(
                    'name' => 'Test Mode',
                    'type' => self::VARIABLE_TYPE_SELECT,
                    'help' => '',
                    'default' => 0,
                    'required' => true,
                    'options' => array (
                        0 => 'No',
                        1 => 'Yes'
                    ),
                )
            )
            ->addVariable (
                self::OPTION_ENABLED,
                array(
                    'name' => 'Enabled',
                    'type' => self::VARIABLE_TYPE_SELECT,
                    'help' => '',
                    'default' => 0,
                    'required' => true,
                    'options' => array (
                        0 => 'No',
                        1 => 'Yes'
                    ),
                )
            );
    }

    public function handle (Request $request)
    {
        //error_log ('LIQPAY Err: ' . json_encode($request->getQuery('data')));

        $order = $this->getCurrentOrder ();
        if ($request->getQuery ('motoorderid')){
            $order = $this->getCurrentOrder ($request->getQuery ('motoorderid'));

            //file_put_contents(dirname(__FILE__).'/log.txt',json_encode($_POST),FILE_APPEND);

            $success = isset($_POST['data']) && isset($_POST['signature']);
            if ($success) {

                $data = $_POST['data'];
                $parsed_data = json_decode(base64_decode($data), true);
                //file_put_contents(dirname(__FILE__).'/log.txt',json_encode($parsed_data),FILE_APPEND);
                $received_public_key = $parsed_data['public_key'];
                $order_id            = $parsed_data['order_id'];
                $status              = $parsed_data['status'];
                $signature           =  $_POST['signature'];
                $transaction_id      = $parsed_data['transaction_id'];
                $order = $this->getCurrentOrder($order_id);
                if ($order) {
                    $private_key = $this->getOption('private_key');
                    $public_key  = $this->getOption('public_key');
                    $generated_signature = base64_encode(sha1($private_key.$data.$private_key, 1));
                    if ($signature  != $generated_signature) {
                        error_log ('LiqPay Err Signature: ' . json_encode(array('data'=>$parsed_data, 'signature'=>$signature)));
                        die("signature secure fail");
                    }
                    if ($public_key != $received_public_key) {
                        error_log ('LiqPay Err Public Key: ' . json_encode($parsed_data));
                        die("public_key secure fail");
                    }
                    if ($status == 'wait_accept' ||$status == 'success' || ($status == 'sandbox' && $this->getOption('sandbox') == 'yes')) {
                        $em = $this->serviceLocator->get('MotoStore\EntityManager');
                        $status = Transaction::PAYMENT_STATUS_PAID;
                        $orderStatus = Order::ORDER_PAYMENT_ACCEPTED;
                        $this->getCart ()->setIsSuccess (true);
                        $transaction = new Transaction ();
                        $transaction->setOrder ($order);
                        $transaction->setTransactionId ($transaction_id);
                        $date = new \DateTime ();
                        $transaction->setDate ($date);
                        $transaction->setPaymentMethod($this->getName ());
                        $transaction->setStatus ($status);
                        $transaction->setAdditional(json_encode ($parsed_data));
                        $em->persist ($transaction);
                        $order->addTransaction ($transaction);
                        $order->setStatus ($orderStatus);
                        $em->merge ($order);
                        $em->flush ();
                        \Moto\Hook::trigger("MOTOSTORE_HOOK_ORDER_PAID",$order->getOrderId());
                        $this->getCart ()->setIsSuccess (true);
                    }
                }
            } else {
                $this->getCart ()->setIsSuccess (true);
                die('IPN Request Failure');
            }

        } else {
            $this->getCart ()->setIsSuccess (true);
        }
        $this->getCart ()->setIsSuccess (true);
    }

    public function checkout (Order $order)
    {
        $names = array_map (function (Product $p) {
            return $p->getName();
        }, $order->getProducts ()->toArray ());
        $params = array(
            'action'      => 'pay',
            'version'     => '3',
            'amount'      => $order->getTotalPrice (),
            'currency'    => strtoupper ($this->getCurrency()->getCode ()),
            'description' => join(', ', $names),
            'order_id'    => $order->getOrderId(),
            'result_url'  => Link::storeLink ('checkout', 'success', array('provider' => $this->getName ()), false),
            'server_url'  => Link::storeLink ('checkout', 'success', array ('provider' => $this->getName (), 'motoorderid' => $order->getOrderId ()), false),
            'language'    => 'ru',
            'sandbox'     => (($this->getOption ('sendbox')==false) ? 0 : 1)
        );
        $params = $this->checkParams($params);
        $request['data'] = base64_encode( json_encode($params) );
        $request['signature'] = $this->cnb_signature($params);
        echo $this->form($this->_apiUrl, $request);
    }


    public function isValidCurrency($currency) {
        if (!in_array($currency, array('RUB', 'UAH', 'USD', 'EUR'))) {
            return false;
        }
        return true;
    }

    private function checkParams($params) {
        $params['public_key'] = $this->getOption ('public_key');
        $params['private_key'] = $this->getOption ('private_key');
        if ($params['currency'] == 'RUR') {
            $params['currency'] = 'RUB';
        }
        return $params;
    }

    public function cnb_signature($params) {
        $params      = $this->checkParams($params);
        $private_key = $this->getOption ('private_key');
        $json      = base64_encode( json_encode($params) );
        $signature = $this->sign($private_key . $json . $private_key);
        return $signature;
    }
    public function sign($str) {
        $signature = base64_encode(sha1($str,1));
        return $signature;
    }

}