<?php

namespace MotoStore\Payment\Webmoney;


use MotoStore\Content\Helper\Link;
use MotoStore\Order\Entity\Order;
use MotoStore\Order\Entity\Transaction;
use MotoStore\Payment\Gateway\PaymentModule;
use Zend\Http\Client;
use Zend\Http\PhpEnvironment\Request;
use Zend\Uri\UriFactory;

class Webmoney extends PaymentModule
{

    /**
     * Get payment processor
     *
     * @return string
     */
    public function getName()
    {
        return 'Webmoney';
    }

    /**
     * Get Payment Icon
     * @return string
     */
    public function getImage()
    {
        return 'logo-webmoney.jpg';
    }

    /**
     * description
     * @return string
     */
    public function getDescription()
    {
        return '';
    }

    /**
     * Help text
     * @return string
     */
    public function getHelpText()
    {
            return "
<h3>For  <a href='https://merchant.wmtransfer.com/conf/purses.asp' target='_blank'>https://merchant.wmtransfer.com/conf/purses.asp</a> settings:</h3>
<p><b>Send parameters in the preliminary inquiry</b>: Yes<br/>
<b>Request method for all</b>: POST<br/>
<b>Control sign forming method</b>: sha256<br/>
</p>
";
    }

    /**
     * Set Payment Variables Array
     * @return array
     */
    public function setVariables()
    {
        $this
            ->addVariable(
                self::OPTION_ENABLED,
                array(
                    'name' => 'Enabled',
                    'type' => self::VARIABLE_TYPE_SELECT,
                    'help' => '',
                    'default' => 0,
                    'required' => true,
                    'options' => array(
                        0 => 'No',
                        1 => 'Yes'
                    ),
                )
            )
            ->addVariable(
                self::OPTION_DISPLAY_NAME,
                array(
                    'name' => 'Display Name',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => '',
                    'default' => 'Webmoney',
                    'required' => true,
                )
            )
            ->addVariable(
                'testmode',
                array(
                    'name' => 'Test Mode',
                    'type' => self::VARIABLE_TYPE_SELECT,
                    'help' => '',
                    'default' => '',
                    'required' => true,
                    'options' => array(
                        '' => 'No',
                        0 => 'All test payments will be successful',
                        1 => 'All test payments will fail',
                        2 => '80% of test payments will be successful, 20% of test payments will fail',
                    ),
                )
            )
            ->addVariable(
                'purse_wmz',
                array(
                    'name' => 'Purse WMZ',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => 'Dollars webmoney purse to which the buyer has to make a payment for billing in dollars.',
                    'default' => 'Z',
                    'required' => true,
                )
            )
            ->addVariable(
                'purse_wmz_secret',
                array(
                    'name' => 'Secret key for WMZ',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => 'Please write Secret key for WMZ purse.',
                    'default' => '',
                    'required' => true,
                )
            )
            ->addVariable(
                'purse_wme',
                array(
                    'name' => 'Purse WME',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => 'Euros webmoney purse to which the buyer has to make a payment for billing in euros.',
                    'default' => 'E',
                    'required' => false,
                )
            )
            ->addVariable(
                'purse_wme_secret',
                array(
                    'name' => 'Secret key for WME',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => 'Please write Secret key for WME purse.',
                    'default' => '',
                    'required' => false,
                )
            )
            ->addVariable(
                'purse_wmr',
                array(
                    'name' => 'Purse WMR',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => 'Russian rubles webmoney purse to which the buyer has to make a payment for billing in rubles.',
                    'default' => 'R',
                    'required' => false,
                )
            )
            ->addVariable(
                'purse_wmr_secret',
                array(
                    'name' => 'Secret key for WMR',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => 'Please write Secret key for WMR purse.',
                    'default' => '',
                    'required' => false,
                )
            )
            ->addVariable(
                'purse_wmu',
                array(
                    'name' => 'Purse WMU',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => 'UAH webmoney purse to which the buyer has to make a payment for billing in UAH.',
                    'default' => 'U',
                    'required' => false,
                )
            )
            ->addVariable(
                'purse_wmu_secret',
                array(
                    'name' => 'Secret key for WMU',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => 'Please write Secret key for WMU purse.',
                    'default' => '',
                    'required' => false,
                )
            )->addVariable(
                'language',
                array(
                    'name' => 'Language interface',
                    'type' => self::VARIABLE_TYPE_SELECT,
                    'help' => '',
                    'default' => 'ru',
                    'required' => true,
                    'options' => array(
                        'ru' => 'Russian',
                        'en' => 'English',
                    ),
                )
            )
            ->addVariable(
                'language_auto',
                array(
                    'name' => 'Language based on the locale?',
                    'type' => self::VARIABLE_TYPE_SELECT,
                    'help' => '',
                    'default' => 'yes',
                    'required' => true,
                    'options' => array(
                        'yes' => 'Yes',
                        'no' => 'No',
                    ),
                )
            );

    }

    /**
     * Handle Success
     *
     * @return mixed
     */
    public function handle(Request $request)
    {
        $LMI_PAYMENT_NO = 0;
        if (array_key_exists('LMI_PAYMENT_NO', $_POST)) {
            $LMI_PAYMENT_NO = $_POST['LMI_PAYMENT_NO'];
        }
        $LMI_PAYMENT_AMOUNT = 0;
        if (array_key_exists('LMI_PAYMENT_AMOUNT', $_POST)) {
            $LMI_PAYMENT_AMOUNT = $_POST['LMI_PAYMENT_AMOUNT'];
        }
        $LMI_PREREQUEST = 0;
        if (array_key_exists('LMI_PREREQUEST', $_POST)) {
            $LMI_PREREQUEST = (int)$_POST['LMI_PREREQUEST'];
        }
        $LMI_PAYEE_PURSE = '';
        if (array_key_exists('LMI_PAYEE_PURSE', $_POST)) {
            $LMI_PAYEE_PURSE = $_POST['LMI_PAYEE_PURSE'];
        }
        $LMI_MODE = 0;
        if (array_key_exists('LMI_MODE', $_POST)) {
            $LMI_MODE = (int)$_POST['LMI_MODE'];
        }
        $LMI_SECRET_KEY = '';
        if (array_key_exists('LMI_SECRET_KEY', $_POST)) {
            $LMI_SECRET_KEY = $_POST['LMI_SECRET_KEY'];
        }
        $LMI_SYS_INVS_NO = 0;
        if (array_key_exists('LMI_SYS_INVS_NO', $_POST)) {
            $LMI_SYS_INVS_NO = $_POST['LMI_SYS_INVS_NO'];
        }
        $LMI_SYS_TRANS_NO = 0;
        if (array_key_exists('LMI_SYS_TRANS_NO', $_POST)) {
            $LMI_SYS_TRANS_NO = $_POST['LMI_SYS_TRANS_NO'];
        }
        $LMI_SYS_TRANS_DATE = '';
        if (array_key_exists('LMI_SYS_TRANS_DATE', $_POST)) {
            $LMI_SYS_TRANS_DATE = $_POST['LMI_SYS_TRANS_DATE'];
        }
        $LMI_PAYER_PURSE = '';
        if (array_key_exists('LMI_PAYER_PURSE', $_POST)) {
            $LMI_PAYER_PURSE = $_POST['LMI_PAYER_PURSE'];
        }
        $LMI_PAYER_WM = '';
        if (array_key_exists('LMI_PAYER_WM', $_POST)) {
            $LMI_PAYER_WM = $_POST['LMI_PAYER_WM'];
        }
        $LMI_CAPITALLER_WMID = '';
        if (array_key_exists('LMI_CAPITALLER_WMID', $_POST)) {
            $LMI_CAPITALLER_WMID = $_POST['LMI_CAPITALLER_WMID'];
        }
        $LMI_PAYMER_EMAIL = '';
        if (array_key_exists('LMI_PAYMER_EMAIL', $_POST)) {
            $LMI_PAYMER_EMAIL = $_POST['LMI_PAYMER_EMAIL'];
        }
        $LMI_PAYER_IP = '';
        if (array_key_exists('LMI_PAYER_IP', $_POST)) {
            $LMI_PAYER_IP = $_POST['LMI_PAYER_IP'];
        }
        $LMI_HASH = '';
        if (array_key_exists('LMI_HASH', $_POST)) {
            $LMI_HASH = $_POST['LMI_HASH'];
        }

        $currency = $this->getCurrency();
        $currency_code = $currency->getCode();
        $local_purse = $this->getPurseFromCurrency($currency_code);;
        $purse = $local_purse['purse'];
        $secret_key = $local_purse['secret_key'];
        $local_hash = strtoupper(hash('sha256', $LMI_PAYEE_PURSE . $LMI_PAYMENT_AMOUNT . $LMI_PAYMENT_NO . $LMI_MODE . $LMI_SYS_INVS_NO . $LMI_SYS_TRANS_NO . $LMI_SYS_TRANS_DATE . $secret_key . $LMI_PAYER_PURSE . $LMI_PAYER_WM));
        $order = $order = $this->getCurrentOrder($LMI_PAYMENT_NO);
        $em = $this->serviceLocator->get('MotoStore\EntityManager');

        if ($order === false && array_key_exists('action', $_GET) && $_GET['action'] !== '') {
            return false;
        }

        if ($_GET['action'] === 'result') {
            if ($LMI_PREREQUEST === 1) {
                die('YES');
            } else {
                $validate = true;
                if (count($LMI_HASH) > 0 && $local_hash !== $LMI_HASH) {
                    $validate = false;
                }
                if ($LMI_SECRET_KEY !== '' && $this->secret_key !== $LMI_SECRET_KEY) {
                    $validate = false;
                }
                if ($validate === true) {

                    $test = false;
                    if ($LMI_MODE === 1) {
                        $test = true;
                    }
                    $transaction = new Transaction ();
                    $transaction->setOrder($order);
                    $transaction->setTransactionId($LMI_SYS_TRANS_NO);
                    $date = new \DateTime ();
                    $transaction->setDate($date);
                    $transaction->setPaymentMethod($this->getName());
                    $transactionStatus = Transaction::PAYMENT_STATUS_PAID;
                    $orderStatus = Order::ORDER_PAYMENT_ACCEPTED;
                    $transaction->setStatus($transactionStatus);
                    $order->setStatus($orderStatus);
                    $transaction->setAdditional(json_encode($request->getQuery()));
                    $em->persist($transaction);
                    $order->addTransaction($transaction);
                    $em->merge($order);
                    $em->flush();
                    $this->getCart()->setIsSuccess(true);
                    \Moto\Hook::trigger("MOTOSTORE_HOOK_ORDER_PAID",$order->getOrderId());
                }
            }
        }
    }


    public function getPurseFromCurrency($currency_code)
    {
        $purseall =
            array(
                'USD' => array(
                    'purse' => $this->getOption('purse_wmz'),
                    'secret' => $this->getOption('purse_wmz_secret')
                ),
                'EUR' => array(
                    'purse' => $this->getOption('purse_wme'),
                    'secret' => $this->getOption('purse_wme_secret')
                ),
                'RUB' => array(
                    'purse' => $this->getOption('purse_wmr'),
                    'secret' => $this->getOption('purse_wmr_secret')
                ),
                'UAH' => array(
                    'purse' => $this->getOption('purse_wmu'),
                    'secret' => $this->getOption('purse_wmu_secret')
                ),
            );
        return $purseall[$currency_code];
    }

    /**
     * Proceed payment
     *
     * @param Order $order
     * @return mixed
     */

    public function checkout(Order $order)
    {
        $formUrl = 'https://merchant.webmoney.ru/lmi/payment.asp';
        $currency = $this->getCurrency();
        $currency_code = $currency->getCode();
        $data_wallet = $this->getPurseFromCurrency($currency_code);
        $names = array();
        foreach ($order->getProducts() as $product) {
            $names [] = $product->getName();
        }
        if ($this->getOption('testmode') !== '') {
            $data['LMI_SIM_MODE'] = $this->getOption('testmode');
        }
        $data['LMI_PAYEE_PURSE'] = $data_wallet['purse'];
        $data['LMI_SUCCESS_URL'] = Link::storeLink('checkout', 'success', array('provider' => $this->getName()), false);
        $data['LMI_RESULT_URL'] = Link::storeLink('payments', null, array('provider' => $this->getName()), false);
        $data['LMI_FAIL_URL'] = Link::storeLink('cart', null, array(), false);
        $data['LMI_PAYMENT_NO'] = $order->getOrderId();
        $data['LMI_PAYMER_EMAIL'] = $order->getEmail();
        $data['LMI_PAYMENT_DESC'] = 'Order #' . $order->getOrderId() . ' [' . join(', ', $names) . ']';
        $args['LMI_PAYMENT_DESC_BASE64'] = base64_encode('Order #' . $order->getOrderId() . ' [' . join(', ', $names) . ']');
        $data['LMI_PAYMENT_AMOUNT'] = rtrim(rtrim($order->getTotalPrice(), ''), '.');
        echo $this->form($formUrl, $data);
    }


}