<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Platform\Auth;


use Doctrine\ORM\EntityManager;
use MotoStore\Customer\Entity\Customer;
use Zend\Authentication\Adapter\AdapterInterface;
use Zend\Authentication\Result;

class DoctrineAdapter implements AdapterInterface
{
    /**
     * @var string
     */
    protected $email;

    /**
     * @var string
     */
    protected $password;

    /**
     * @var EntityManager
     */
    protected $entityManager;
    /**
     * Performs an authentication attempt
     *
     * @return \Zend\Authentication\Result
     * @throws \Zend\Authentication\Adapter\Exception\ExceptionInterface If authentication cannot be performed
     */
    public function authenticate ()
    {
        $q = $this
            ->entityManager
            ->createQueryBuilder ();

        $customer = $q
            ->select (array ('c'))
            ->from ('MotoStore\Customer\Entity\Customer', 'c')
            ->where ($q->expr ()->eq ('c.active', Customer::CUSTOMER_ACTIVE))
            ->andWhere ($q->expr ()->eq ('c.email', '?1'))
            ->andWhere ($q->expr ()->eq ('c.password', '?2'))
            ->setParameters (array (
                1 => $this->email,
                2 => self::createPasswordHash ($this->email, $this->password),
            ))
            ->getQuery ()
            ->getResult();

        if ($customer)
        {
            return new Result (Result::SUCCESS, $customer [0], array ());
        }

        return new Result (Result::FAILURE, $customer, array ());
    }

    /**
     * @param string $email
     */
    public function setEmail ($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @param string $password
     */
    public function setPassword ($password)
    {
        $this->password = $password;

        return $this;
    }

    /**
     * @param EntityManager $entityManager
     */
    public function setEntityManager ($entityManager)
    {
        $this->entityManager = $entityManager;
    }

    /**
     * Create Password
     *
     * @param $email
     * @param $password
     * @return string
     */
    public static function createPasswordHash ($email, $password)
    {
        $chunks = explode (substr ($email, 0, 1), $password . $email);

        asort ($chunks);

        return hash (
            'sha256',
            join ('$-/!', $chunks)
        );
    }

    /**
     * Create Random Password
     *
     * @param int $length
     * @return string
     */
    public static function generatePassword ($length = 6)
    {
        $chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_!@#$%^&*()-+=";

        return substr (str_shuffle ($chars), 0, $length);
    }
}