<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Platform\Doctrine\Cache;


use Doctrine\Common\Cache\FilesystemCache;

class AnnotationCachePattern extends FilesystemCache
{
    /**
     * @var string[] regular expressions for replacing disallowed characters in file name
     */
    private $disallowedCharacterPatterns = array(
        '/\-/', // replaced to disambiguate original `-` and `-` derived from replacements
        '/[^a-zA-Z0-9\-_\[\]]/' // also excludes non-ascii chars (not supported, depending on FS)
    );

    /**
     * @var string[] replacements for disallowed file characters
     */
    private $replacementCharacters = array('__', '-');

    private $extension = '.dc.annotation';


    /**
     * @param string $id
     *
     * @return string
     */
    protected function getFilename($id)
    {
        return $this->directory
        . DIRECTORY_SEPARATOR
        . preg_replace($this->disallowedCharacterPatterns, $this->replacementCharacters, $id)
        . $this->extension;
    }

}