<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Platform\From\Validator;


use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Mailer\Agent;
use Zend\Validator\AbstractValidator;
use Zend\Validator\Exception;

class EmailTemplate extends AbstractValidator
{
    const NOT_VALID = 'notValidTemplate';
    /**
     * Validation failure message template definitions
     *
     * @var array
     */
    protected $messageTemplates = array(
        self::NOT_VALID   => "The template is invalid",
    );

    /** @var  Agent */
    private $mailAgent;

    public function __construct($options = array())
    {
        $this->mailAgent = SMStatic::getInstance()->get ('store.mailer');

        parent::__construct($options);
    }

    public function isValid($value)
    {
        try
        {
            $this->mailAgent->getRenderer ()->render ($value);
        }
        catch (\Exception $e)
        {
            $this->error (self::NOT_VALID);
            return false;
        }
        return true;
    }
}