<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Platform\From\Validator;


use Zend\Validator\AbstractValidator;
use Zend\Validator\Exception;

class Numeric extends AbstractValidator
{
    const NOT_DIGITS = 'notDigits';
    /**
     * Validation failure message template definitions
     *
     * @var array
     */
    protected $messageTemplates = array(
        self::NOT_DIGITS   => "The input must contain only digits",
    );
    /**
     * Returns true if and only if $value meets the validation requirements
     *
     * If $value fails validation, then this method returns false, and
     * getMessages() will return an array of messages that explain why the
     * validation failed.
     *
     * @param  mixed $value
     * @return bool
     * @throws Exception\RuntimeException If validation of $value is impossible
     */
    public function isValid ($value)
    {
        if (!is_numeric ($value))
        {
            $this->error (self::NOT_DIGITS);

            return false;
        }

        if (array_key_exists ('min', $this->abstractOptions))
        {
            if ($value < $this->abstractOptions ['min'])
            {
                $this->error (self::NOT_DIGITS);

                return false;
            }
        }

        if (array_key_exists ('max', $this->abstractOptions))
        {
            if ($value > $this->abstractOptions ['max'])
            {
                $this->error (self::NOT_DIGITS);

                return false;
            }
        }


        return true;
    }
}