<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Platform\From\Validator;


use Doctrine\ORM\EntityManager;
use Zend\InputFilter\Input;
use Zend\Validator\AbstractValidator;
use Zend\Validator\Exception;

class Unique extends AbstractValidator
{
    const NOT_UNIQUE = 'recordFound';
    /**
     * Validation failure message template definitions
     *
     * @var array
     */
    protected $messageTemplates = array(
        self::NOT_UNIQUE   => "The input already in use",
    );
    /**
     * Returns true if and only if $value meets the validation requirements
     *
     * If $value fails validation, then this method returns false, and
     * getMessages() will return an array of messages that explain why the
     * validation failed.
     *
     * @param  mixed $value
     * @return bool
     * @throws Exception\RuntimeException If validation of $value is impossible
     */
    public function isValid ($value)
    {
        /**
         * @var EntityManager $entityManager
         */
        $entityManager  = $this->abstractOptions ['entityManager'];
        $entity         = $this->abstractOptions ['entity'];
        $uniqueField    = $this->abstractOptions ['uniqueField'];
        $excludeField   = $this->abstractOptions ['exclude'];

        if ($excludeField instanceof Input)
        {
            $excludeField = $excludeField->getValue ();
        }

        $isset = $entityManager
            ->getRepository ($entity)
            ->findOneBy (array ($uniqueField => $value));


        if ($isset)
        {
            /**
             * If exists exclude identifier end isnt empty
             */
            if (empty ($excludeField) || (!empty ($excludeField) && $excludeField != $isset->getId ()))
            {
                $this->error (self::NOT_UNIQUE);
                return false;
            }
        }
        return true;
    }
}