<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Platform\Module;

use MotoStore\Platform\Application;
use Zend\ServiceManager\Config;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\Stdlib\ArrayUtils;

class Manager
{
    /**
     * @var ServiceLocatorInterface
     */
    protected $serviceLocator = null;


    /**
     * Loaded Modules
     *
     * @var array
     */
    private $attachedModules = array ();


    /**
     * Merged Modules Config
     *
     * @var array
     */
    private $modulesConfigs = array ();


    /**
     * Set service locator
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function setServiceLocator (ServiceLocatorInterface $serviceLocator)
    {
        $this->serviceLocator = $serviceLocator;

        return $this;
    }


    /**
     * Get service locator
     *
     * @return ServiceLocatorInterface
     */
    public function getServiceLocator ()
    {
        return $this->serviceLocator;
    }


    /**
     * Load Module
     *
     * @param ModuleAbstract $module
     */
    public function attachModule (ModuleAbstract $module)
    {
        if (!$this->isModuleAttached ($module->getName ()))
        {
            $module
                ->setServiceLocator ($this->getServiceLocator ());

            $this->attachedModules [$module->getName ()] = $module;

            $this->modulesConfigs = ArrayUtils::merge ($this->modulesConfigs, $module->getModuleConfig ());

            $module->bootstrap ();
        }
    }


    /**
     * Check is module loaded
     *
     * @param $moduleName
     * @return bool
     */
    public function isModuleAttached ($moduleName)
    {
        return array_key_exists ($moduleName, $this->attachedModules);
    }


    /**
     * Return merged service manager config
     *
     * @return array
     */
    protected function getServiceManagerConfigs ()
    {
        if (isset ($this->modulesConfigs ['service_manager']))
        {
            return $this->modulesConfigs ['service_manager'];
        }

        return array ();
    }


    /**
     * Apply service manager configs
     */
    public function applyServices ()
    {
        $configure = new Config ($this->getServiceManagerConfigs ());

        $this->getServiceLocator ()
            ->setService (Application::STORE_CONFIG, $this->modulesConfigs);

        $configure
            ->configureServiceManager ($this->getServiceLocator());

        unset ($this->modulesConfigs);
    }

    /**
     * @return array
     */
    public function getModulesConfigs ()
    {
        return $this->modulesConfigs;
    }

    /**
     * @param array $modulesConfigs
     */
    public function setModulesConfigs ($modulesConfigs)
    {
        $this->modulesConfigs = $modulesConfigs;
    }
}