<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product;

use Moto;
use MotoStore\Platform\Module\ModuleAbstract;

class Module extends ModuleAbstract
{
    /**
     * Return module config
     *
     * @return array
     */
    public function getModuleConfig ()
    {
        return include __DIR__ . DIRECTORY_SEPARATOR .  'config' . DIRECTORY_SEPARATOR . 'module.config.php';
    }

    /**
     * Module Name
     * @return string
     */
    public function getName ()
    {
        return 'Product';
    }


    public function bootstrap()
    {
        $this->bootstrapLinker ();
    }

    /**
     * Load options for linker component
     */
    private function bootstrapLinker ()
    {
        Moto\ClickAction\Factory::init ();

        Moto\ClickAction\Factory::setClickAction ('store.category', array (
            'renderClass' => 'MotoStore\Product\Link\Category',
            'filter' => 'MotoStore\Product\Link\CategoryValidator',
            'validator' => 'MotoStore\Product\Link\CategoryValidator',
        ));

        Moto\ClickAction\Factory::setClickAction ('store.product', array (
            'renderClass' => 'MotoStore\Product\Link\Product',
            'filter' => 'MotoStore\Product\Link\ProductValidator',
            'validator' => 'MotoStore\Product\Link\ProductValidator',
        ));
    }
}