<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Entity\Category;

use Doctrine\ORM\Mapping as ORM;
use MotoStore\Platform\Locale\LocaleInterface;
use MotoStore\Product\Entity\Category;

/** @ORM\Entity
 * @ORM\Table(name="store_category_locale",options={"engine":"InnoDB"})
 */
class Locale implements LocaleInterface
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /** @ORM\Column(type="integer") */
    protected $category_id;

    /** @ORM\Column(type="string") */
    protected $language_code;

    /** @ORM\Column(type="string") */
    protected $name;

    /** @ORM\Column(type="string", nullable=true) */
    protected $keywords;

    /** @ORM\Column(type="string", nullable=true) */
    protected $meta_description;

    /** @ORM\Column(type="text", nullable=true) */
    protected $short_description;

    /** @ORM\Column(type="string", nullable=true) */
    protected $meta_title;


    /** @ORM\Column(type="string", nullable=true) */
    protected $og_title;

    /** @ORM\Column(type="string", nullable=true) */
    protected $og_description;

    /** @ORM\Column(type="string", nullable=true) */
    protected $og_url;

    /** @ORM\Column(type="string", nullable=true) */
    protected $og_image;


    /** @ORM\Column(type="text", nullable=true) */
    protected $canonical_url;

    /** @ORM\Column(type="text", nullable=true) */
    protected $description;

    /** @ORM\Column(type="boolean") */
    protected $noindex = false;

    /** @ORM\Column(type="boolean") */
    protected $nofollow = false;

    /** @ORM\Column(type="boolean") */
    protected $hide_canonical = false;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Category", inversedBy="locales")
     * @ORM\JoinColumn(name="category_id", referencedColumnName="id", onDelete="CASCADE")
     * @var \MotoStore\Product\Entity\Category
     */
    protected $category;


    public function __construct ($language_code=null)
    {
        if ($language_code)
        {
            $this->setLanguageCode ($language_code);
        }
    }


    /**
     * @param mixed $category
     */
    public function addCategory(Category $category)
    {
        $this->category = $category;
    }


    /**
     * @return \MotoStore\Product\Entity\Category
     */
    public function getCategory ()
    {
        return $this->category;
    }


    /**
     * @param mixed $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }


    /**
     * @return mixed
     */
    public function getDescription()
    {
        return $this->description;
    }


    /**
     * @param mixed $category_id
     */
    public function setCategoryId ($category_id)
    {
        $this->category_id = $category_id;
    }


    /**
     * @return mixed
     */
    public function getCategoryId ()
    {
        return $this->category_id;
    }


    /**
     * @param mixed $category_meta_description
     */
    public function setMetaDescription($category_meta_description)
    {
        $this->meta_description = $category_meta_description;
    }


    /**
     * @return mixed
     */
    public function getMetaDescription()
    {
        return $this->meta_description;
    }


    /**
     * @param mixed $category_meta_keywords
     */
    public function setKeywords ($category_meta_keywords)
    {
        $this->keywords = $category_meta_keywords;
    }


    /**
     * @return mixed
     */
    public function getKeywords ()
    {
        return $this->keywords;
    }
    /**
     * @param string $og_title
     */
    public function setOgTitle ($og_title)
    {
        $this->og_title = $og_title;
    }

    /**
     * @return string
     */
    public function getOgTitle ()
    {
        return $this->og_title;
    }

    /**
     *
     * @param string $og_url
     */
    public function setOgUrl ($og_url)
    {
        $this->og_url = $og_url;
    }

    /**
     * @return string
     */
    public function getOgUrl ()
    {
        return $this->og_url;
    }

    /**
     *
     * @param string $og_description
     */
    public function setOgDescription ($og_description)
    {
        $this->og_description = $og_description;
    }

    /**
     * @return string
     */
    public function getOgDescription ()
    {
        return $this->og_description;
    }

    /**
     *
     * @param string $og_image
     */
    public function setOgImage ($og_image)
    {
        $this->og_image = $og_image;
    }

    /**
     * @return string
     */
    public function getOgImage ()
    {
        return $this->og_image;
    }

    /**
     * @param mixed $category_name
     */
    public function setName ($category_name)
    {
        $this->name = $category_name;
    }


    /**
     * @return mixed
     */
    public function getName ()
    {
        return $this->name;
    }


    /**
     * @param mixed $category_short_description
     */
    public function setShortDescription ($category_short_description)
    {
        $this->short_description = $category_short_description;
    }


    /**
     * @return mixed
     */
    public function getShortDescription ()
    {
        return $this->short_description;
    }


    /**
     * @param mixed $id
     */
    public function setId ($id)
    {
        $this->id = $id;
    }


    /**
     * @return mixed
     */
    public function getId ()
    {
        return $this->id;
    }


    /**
     * @param mixed $language_code
     */
    public function setLanguageCode($language_code)
    {
        $this->language_code = $language_code;
    }


    /**
     * @return mixed
     */
    public function getLanguageCode()
    {
        return $this->language_code;
    }

    /**
     * @param bool $noindex
     */
    public function setNoindex ($noindex)
    {
        $this->noindex = $noindex;
    }


    /**
     * @return mixed
     */
    public function getNoindex ()
    {
        return $this->noindex;
    }

    /**
     * @param bool $nofollow
     */
    public function setNofollow ($nofollow)
    {
        $this->nofollow = $nofollow;
    }


    /**
     * @return mixed
     */
    public function getNofollow ()
    {
        return $this->nofollow;
    }

    /**
     * @param bool $hide_canonical
     */
    public function setHideCanonical ($hide_canonical)
    {
        $this->hide_canonical = $hide_canonical;
    }


    /**
     * @return mixed
     */
    public function getHideCanonical ()
    {
        return $this->hide_canonical;
    }

    /**
     * @param string $meta_title
     */
    public function setMetaTitle ($meta_title)
    {
        $this->meta_title = $meta_title;
    }

    /**
     * @return string
     */
    public function getMetaTitle ()
    {
        return $this->meta_title;
    }

    /**
     * @param string $canonical_url
     */
    public function setCanonicalUrl ($canonical_url)
    {
        $this->canonical_url = $canonical_url;
    }

    /**
     * @return string
     */
    public function getCanonicalUrl ()
    {
        return $this->canonical_url;
    }
}