<?php


namespace MotoStore\Product\Entity\Category;

use Doctrine\ORM\Mapping as ORM;

/** @ORM\Entity @ORM\Table (name="store_category_relation",options={"engine":"InnoDB"}) */
class Relation
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     */
    protected $product_id;

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     */
    protected $category_id;

    /**
     * @ORM\Column(type="integer",  options={"default" : 0})
     */
    protected $position = 0;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Category")
     * @ORM\JoinColumn(name="category_id", referencedColumnName="id", onDelete="CASCADE")
     *
     */
    protected $category;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Product")
     * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="CASCADE")
     *
     */
    protected $product;

    /**
     * @return mixed
     */
    public function getProductId()
    {
        return $this->product_id;
    }

    /**
     * @param mixed $product_id
     * @return $this
     */
    public function setProductId($product_id)
    {
        $this->product_id = $product_id;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getCategoryId()
    {
        return $this->category_id;
    }

    /**
     * @param mixed $category_id
     * @return $this
     */
    public function setCategoryId ($category_id)
    {
        $this->category_id = $category_id;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getPosition ()
    {
        return $this->position;
    }

    /**
     * @param mixed $position
     * @return $this
     */
    public function setPosition ($position)
    {
        $this->position = $position;
        return $this;
    }
}