<?php
namespace MotoStore\Product\Entity\CategoryBrand;

use Doctrine\ORM\Mapping as ORM;
use MotoStore\Product\Entity\Property;

/** @ORM\Entity @ORM\Table (name="store_category_brand_relation",options={"engine":"InnoDB"}) */
class Relation
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $category_id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $brand_id;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Brand")
     * @ORM\JoinColumn(name="brand_id", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $brand;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Category", inversedBy="brands")
     * @ORM\JoinColumn(name="category_id", referencedColumnName="id")
     * @var \MotoStore\Product\Entity\Category
     */

    protected $category;



    /**
     * @return mixed
     */
    public function getId ()
    {
        return $this->id;
    }


    /**
     * @param mixed $id
     */
    public function setId ($id)
    {
        $this->id = $id;
    }





    /**
     * @return \MotoStore\Product\Entity\Brand
     */
    public function getBrand ()
    {
        return $this->brand;
    }


    /**
     * @param mixed $brand
     */
    public function setBrand ($brand)
    {
        $this->brand = $brand;
    }


    /**
     * @return mixed
     */
    public function getBrandId ()
    {
        return $this->brand_id;
    }


    /**
     * @param mixed $brand_id
     */
    public function setBrandId ($brand_id)
    {
        $this->brand_id = $brand_id;
    }
    /**
     * @return \MotoStore\Product\Entity\Category
     */
    public function getCategory ()
    {
        return $this->category;
    }


    /**
     * @param \MotoStore\Product\Entity\Category $category
     */
    public function setCategory ($category)
    {
        $this->category = $category;
    }


}