<?php
namespace MotoStore\Product\Entity\CategoryProperty;

use Doctrine\ORM\Mapping as ORM;
use MotoStore\Product\Entity\Property;

/** @ORM\Entity @ORM\Table (name="store_category_property_relation",options={"engine":"InnoDB"}) */
class Relation
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $category_id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $property_id;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Property")
     * @ORM\JoinColumn(name="property_id", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $property;
    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Category", inversedBy="properties")
     * @ORM\JoinColumn(name="category_id", referencedColumnName="id")
     * @var \MotoStore\Product\Entity\Category
     */
    protected $category;

    /**
     * @return mixed
     */
    public function getId ()
    {
        return $this->id;
    }


    /**
     * @param mixed $id
     */
    public function setId ($id)
    {
        $this->id = $id;
    }



    /**
     * @return \MotoStore\Product\Entity\Property
     */
    public function getProperty ()
    {
        return $this->property;
    }


    /**
     * @param mixed $property
     */
    public function setProperty ($property)
    {
        $this->property = $property;
    }


    /**
     * @return mixed
     */
    public function getPropertyId ()
    {
        return $this->property_id;
    }


    /**
     * @param mixed $property_id
     */
    public function setPropertyId ($property_id)
    {
        $this->property_id = $property_id;
    }
    /**
     * @return \MotoStore\Product\Entity\Category
     */
    public function getCategory ()
    {
        return $this->category;
    }


    /**
     * @param \MotoStore\Product\Entity\Category $category
     */
    public function setCategory ($category)
    {
        $this->category = $category;
    }

}