<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Entity;

use Doctrine\ORM\Mapping as ORM;
use MotoStore\Product\Entity\Product;
use MotoStore\Platform\Entity\Media;

/** @ORM\Entity @ORM\Table (name="store_product_media",options={"engine":"InnoDB"}) */

class MediaRelation
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $product_id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $media_id;

    /**
     * @ORM\Column(type="integer" , options={"default" : 0})
     */
    protected $position = 0 ;


    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Platform\Entity\Media")
     * @ORM\JoinColumn(name="media_id", referencedColumnName="id", onDelete="CASCADE")
     * @var \MotoStore\Platform\Entity\Media
     */
    protected $media;


    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Product", inversedBy="properties")
     * @ORM\JoinColumn(name="product_id", referencedColumnName="id")
     * @var \MotoStore\Product\Entity\Product
     */
    protected $product;

    /**
     * @return mixed
     */
    public function getId ()
    {
        return $this->id;
    }


    /**
     * @param mixed $id
     */
    public function setId ($id)
    {
        $this->id = $id;
    }


    /**
     * @return \MotoStore\Product\Entity\Product
     */
    public function getProduct ()
    {
        return $this->product;
    }


    /**
     * @param \MotoStore\Product\Entity\Product $product
     */
    public function setProduct ($product)
    {
        $this->product = $product;
    }


    /**
     * @return mixed
     */
    public function getProductId ()
    {
        return $this->product_id;
    }


    /**
     * @param mixed $product_id
     */
    public function setProductId($product_id)
    {
        $this->product_id = $product_id;
    }


    /**
     * @return \MotoStore\Platform\Entity\Media
     */
    public function getMedia ()
    {
        return $this->media;
    }


    /**
     * @param mixed $media
     */
    public function setMedia ($media)
    {
        $this->media = $media;
    }


    /**
     * @return mixed
     */
    public function getMediaId ()
    {
        return $this->media_id;
    }


    /**
     * @param mixed $media_id
     */
    public function setMediaId ($media_id)
    {
        $this->media_id = $media_id;
    }


    /**
     * @param mixed $position
     */
    public function setPosition ($position)
    {
        $this->position = $position;
    }


    /**
     * @return mixed
     */
    public function getPosition ()
    {
        return $this->position;
    }
}