<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="store_product_option",options={"engine":"InnoDB"})
 */
class Option
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $product_id;

    /**
     * @ORM\Column(type="integer")
     * @var int
     */
    protected $position;


    /** @ORM\Column(type="string", nullable=true) */
    protected $name;

    /**
     * @ORM\OneToMany(
     *  targetEntity="MotoStore\Product\Entity\OptionValue", mappedBy="option", cascade={"persist", "remove"},
     *  orphanRemoval=true
     * )
     */
    protected $values;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Product", inversedBy="options")
     * @ORM\JoinColumn(name="product_id", referencedColumnName="id")
     * @var \MotoStore\Product\Entity\Product
     */
    protected $product;


    public function __construct ()
    {
        $this->values = new ArrayCollection ();
    }


    public function __clone()
    {
        $values = $this->getValues();
        $this->values  = new ArrayCollection();
        if(count($values) > 0){
            foreach ($values as $value) {
                $cloneValue = clone $value;
                $this->values->add($cloneValue);
                $cloneValue->setOption($this);
            }
        }
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getProductId()
    {
        return $this->product_id;
    }

    /**
     * @param mixed $product_id
     */
    public function setProductId($product_id)
    {
        $this->product_id = $product_id;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return ArrayCollection
     */
    public function getValues()
    {
        return $this->values;
    }

    /**
     * @param ArrayCollection $values
     */
    public function setValues ($values)
    {
        $this->values = $values;
    }

    /**
     * @return \MotoStore\Product\Entity\Product
     */
    public function getProduct()
    {
        return $this->product;
    }

    /**
     * @param \MotoStore\Product\Entity\Product $product
     */
    public function setProduct($product)
    {
        $this->product = $product;
    }

    /**
     * @return int
     */
    public function getPosition()
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition($position)
    {
        $this->position = $position;
    }

    /**
     *
     * @param $value_id
     * @return OptionValue Option
     */
    public function getValue ($value_id)
    {
        return $this
            ->getValues ()
            ->filter (
                function (OptionValue $v) use ($value_id) {
                    return $v->getId() == $value_id;
                }
            )->first ();
    }

    /**
     *
     * @param $name
     * @return OptionValue Option
     */
    public function getValueByName ($name)
    {
        return $this
            ->getValues ()
            ->filter (
                function (OptionValue $v) use ($name) {
                    return $v->getName () == $name;
                }
            )->first ();
    }

}