<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use MotoStore\Product\Entity\Property\Value;

/**
 * @ORM\Entity
 * @ORM\Table(name="store_product_property",options={"engine":"InnoDB"})
 */
class Property
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @ORM\Column(type="string")
     */
    protected $name;

    /**
     * @ORM\Column(type="string", nullable=true)
     */
    protected $image;


    /**
     * @ORM\OneToMany(targetEntity="MotoStore\Product\Entity\Property\Value", mappedBy="property", cascade={"persist", "remove"}, orphanRemoval=true)
     */
    protected $values;

    public function __construct ()
    {
        $this->values = new ArrayCollection ();
    }

    /**
     * @return mixed
     */
    public function getId ()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId ($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getName ()
    {
        return $this->name;
    }

    /**
     * @param mixed $image
     */
    public function setImage ($image)
    {
        $this->image = $image;
    }
    /**
     * @return mixed
     */
    public function getImage ()
    {
        return $this->image;
    }

    /**
     * @param mixed $name
     */
    public function setName ($name)
    {
        $this->name = $name;
    }

    /**
     * @return ArrayCollection
     */
    public function getValues ()
    {
        return $this->values;
    }

    /**
     * @param Value $value
     */
    public function addValue (Value $value)
    {
        $this->values->add ($value);
    }

    /**
     * @param Value $value
     */
    public function removeValue (Value $value)
    {
        $this->values->removeElement ($value);
    }
}