<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Entity\Property;

use Doctrine\ORM\Mapping as ORM;
use MotoStore\Product\Entity\Property;

/** @ORM\Entity @ORM\Table (name="store_product_property_relation",options={"engine":"InnoDB"}) */
class Relation
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $product_id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $property_id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $value_id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $position;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Property")
     * @ORM\JoinColumn(name="property_id", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $property;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Property\Value")
     * @ORM\JoinColumn(name="value_id", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $value;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Product", inversedBy="properties")
     * @ORM\JoinColumn(name="product_id", referencedColumnName="id")
     * @var \MotoStore\Product\Entity\Product
     */
    protected $product;

    /**
     * @return mixed
     */
    public function getId ()
    {
        return $this->id;
    }


    /**
     * @param mixed $id
     */
    public function setId ($id)
    {
        $this->id = $id;
    }


    /**
     * @return \MotoStore\Product\Entity\Product
     */
    public function getProduct ()
    {
        return $this->product;
    }


    /**
     * @param \MotoStore\Product\Entity\Product $product
     */
    public function setProduct ($product)
    {
        $this->product = $product;
    }


    /**
     * @return mixed
     */
    public function getProductId ()
    {
        return $this->product_id;
    }


    /**
     * @param mixed $product_id
     */
    public function setProductId($product_id)
    {
        $this->product_id = $product_id;
    }


    /**
     * @return \MotoStore\Product\Entity\Property
     */
    public function getProperty ()
    {
        return $this->property;
    }


    /**
     * @param mixed $property
     */
    public function setProperty ($property)
    {
        $this->property = $property;
    }


    /**
     * @return mixed
     */
    public function getPropertyId ()
    {
        return $this->property_id;
    }


    /**
     * @param mixed $property_id
     */
    public function setPropertyId ($property_id)
    {
        $this->property_id = $property_id;
    }


    /**
     * @return Value
     */
    public function getValue ()
    {
        return $this->value;
    }


    /**
     * @param mixed $value
     */
    public function setValue ($value)
    {
        $this->value = $value;
    }


    /**
     * @return mixed
     */
    public function getValueId ()
    {
        return $this->value_id;
    }


    /**
     * @param mixed $value_id
     */
    public function setValueId ($value_id)
    {
        $this->value_id = $value_id;
    }


    /**
     * @param mixed $position
     */
    public function setPosition ($position)
    {
        $this->position = $position;
    }


    /**
     * @return mixed
     */
    public function getPosition ()
    {
        return $this->position;
    }
}