<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Entity;

use Doctrine\ORM\Mapping as ORM;
/**
 * Class TierPrice
 * @package MotoStore\Product\Entity
 * @ORM\Entity
 * @ORM\Table(name="store_product_tier_price",options={"engine":"InnoDB"})
 */
class TierPrice
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $product_id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $quantity;


    /** @ORM\Column(type="decimal", precision=10, scale=2) */
    protected  $price;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Product", inversedBy="tier_prices")
     * @ORM\JoinColumn(name="product_id", referencedColumnName="id")
     * @var \MotoStore\Product\Entity\Product
     */
    protected $product;

    /**
     * TierPrice constructor.
     * @param $quantity
     * @param $price
     * @param Product $product
     */
    public function __construct($quantity = 0, $price = 0, Product $product = null)
    {
        $this->quantity = $quantity;
        $this->price = $price;
        $this->product = $product;
    }


    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getProductId()
    {
        return $this->product_id;
    }

    /**
     * @param mixed $product_id
     */
    public function setProductId($product_id)
    {
        $this->product_id = $product_id;
    }

    /**
     * @return mixed
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param mixed $quantity
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;
    }

    /**
     * @return mixed
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @param mixed $price
     */
    public function setPrice($price)
    {
        $this->price = $price;
    }

    /**
     * @return Product
     */
    public function getProduct()
    {
        return $this->product;
    }

    /**
     * @param Product $product
     */
    public function setProduct($product)
    {
        $this->product = $product;
    }
    
    
}