<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use MotoStore\Product\Entity\Variant\VariantOption;

/**
 * @ORM\Entity
 * @ORM\Table(name="store_product_variant",options={"engine":"InnoDB"})
 */
class Variant
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $product_id;

    /** @ORM\Column(type="string", nullable=true) */
    protected $sku;

    /**
     * @ORM\Column(type="decimal", precision=10, scale=2)
     */
    protected $price = 0;

    /**
     * @ORM\Column(type="integer")
     */
    protected $quantity = 0;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Platform\Entity\Media")
     * @ORM\JoinColumn(name="image_id", referencedColumnName="id", onDelete="SET NULL")
     *
     */
    protected $image;

    /**
     * @ORM\OneToMany(
     *  targetEntity="MotoStore\Product\Entity\Variant\VariantOption", mappedBy="variant", cascade={"persist", "remove"},
     *  orphanRemoval=true
     * )
     */
    protected $options;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Product", inversedBy="variants")
     * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="CASCADE")
     * @var \MotoStore\Product\Entity\Product
     */
    protected $product;


    public function __construct ()
    {
        $this->options = new ArrayCollection ();
    }

    public function __clone()
    {

        /*Clone options*/
        $options = $this->getOptions();
        $this->options  = new ArrayCollection();
        if(count($options) > 0){
            foreach ($options as $option) {
                $cloneOption = clone $option;
                $this->options->add($cloneOption);
                $cloneOption->setVariant($this);

            }
        }
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getProductId()
    {
        return $this->product_id;
    }

    /**
     * @param mixed $product_id
     */
    public function setProductId($product_id)
    {
        $this->product_id = $product_id;
    }

    /**
     * @return mixed
     */
    public function getSku()
    {
        return $this->sku;
    }

    /**
     * @param mixed $sku
     */
    public function setSku($sku)
    {
        $this->sku = $sku;
    }

    /**
     * @return mixed
     */
    public function getPrice()
    {
        return (float) $this->price;
    }

    /**
     * @param mixed $price
     */
    public function setPrice($price)
    {
        $this->price = $price;
    }

    /**
     * @return ArrayCollection
     */
    public function getOptions()
    {
        return $this->options;
    }

    /**
     * @param ArrayCollection $options
     */
    public function setOptions($options)
    {
        $this->options = $options;
    }

    /**
     * @return mixed
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * @param mixed $image
     */
    public function setImage($image)
    {
        $this->image = $image;
    }

    /**
     * @return Product
     */
    public function getProduct()
    {
        return $this->product;
    }

    /**
     * @param Product $product
     */
    public function setProduct($product)
    {
        $this->product = $product;
    }

    /**
     * @return mixed
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param mixed $quantity
     * @return $this
     */
    public function setQuantity ($quantity)
    {
        $this->quantity = $quantity;
        return $this;
    }

    /**
     *
     * @param $id
     * @return VariantOption
     */
    public function getOption ($id)
    {
        return $this
            ->options
            ->filter (
                function (VariantOption $o) use ($id) {
                    return $o->getId() == $id;
                }
            )->first ();
    }
    
    public function getOptionByOptionId ($option_id)
    {
        return $this
            ->options
            ->filter (
                function (VariantOption $o) use ($option_id) {
                    return $o->getOptionId () == $option_id;
                }
            )->first ();
    }

    public function trackInventory ($count = 0, $trackInventory = true, $allowNegative = false)
    {
        $result = true;

        if ($trackInventory)
        {
            $inventory = $this->getQuantity () - $count;

            if ($inventory >= 0 || $allowNegative)
            {
                $this->setQuantity ($inventory);
            }
            else
            {
                $result = false;
            }
        }
        return $result;
    }
    
}