<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product\Form;


use MotoStore\Platform\Doctrine\Strategy\LocalesStrategy;
use MotoStore\Platform\Form\FormTypeAbstract;
use MotoStore\Product\Entity\Brand;
use MotoStore\Product\Entity\Product;

class BrandType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array ();
    }

    /**
     * Build Form
     */
    public function init ()
    {
        $this
            ->add (array (
                'name'      => 'name',
                'required'  => true,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 1,
                            'max' => 255,
                        )
                    )

                ),
            ))
            ->add (array (
                'name'      => 'uri',
                'required'  => true,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 1,
                            'max' => 255,
                        )
                    )

                ),
            ))
            ->add (array (
                'name'      => 'description',
                'required'  => false,
            ));
    }

    /**
     * @param $data
     * @param Brand $entity
     */
    protected function onPresetData (&$data, $entity)
    {
        $this->applyMainImage ($data, $entity);
    }

    /**
     * Main Image
     *
     * @param $data
     * @param Brand $entity
     */
    protected function applyMainImage ($data, Brand $entity)
    {
        $image = null;

        if (!empty ($data ['image'] ['id']))
        {
            $image = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Platform\Entity\Media')
                ->find ($data ['image'] ['id']);
        }

        $entity->attachImage ($image);
    }
}