<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product\Form;


use MotoStore\Platform\Form\FormTypeAbstract;
use MotoStore\Product\Entity\Category;
use MotoStore\Platform\Form\Filter\DefaultValue;
use MotoStore\Product\Entity\Product;
use Zend\InputFilter\CollectionInputFilter;

class CategoryType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array ();
    }

    /**
     * Build Form
     */
    public function init ()
    {
        $locales = new CollectionInputFilter ();

        $localeType = new CategoryLocaleType ();
        $localeType
            ->setEntityManager ($this->getEntityManager ())
            ->init ();


        $locales
            ->setInputFilter ($localeType);

        $this
            ->add (array (
                'name'      => 'parent_id',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'Digits',
                    )
                ),
            ))
            ->add (array (
                'name'      => 'id',
                'required'  => false,
            ))
            ->add (array (
                'name'      => 'order',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'Digits',
                    )
                ),
            ))

            ->add (array (
                'name'      => 'btob',
                'required'  => false,
            ))
            ->add (array (
                'name'      => 'uri',
                'required'  => true,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 255,
                        )
                    ),
                    array (
                        'name' => 'MotoStore\Platform\From\Validator\Unique',
                        'options' => array (
                            'entityManager' => $this->getEntityManager (),
                            'entity'        => 'MotoStore\Product\Entity\Category',
                            'uniqueField'   => 'uri',
                            'exclude'    => $this->get('id'),
                        )
                    )

                ),
            ))
            ->add ($locales, 'locales');
    }

    /**
     * @param $data
     * @param Category $entity
     */
    protected function onPresetData (&$data, $entity)
    {
        $this->applyLocales ($data, $entity);
        $this->applyImage ($data, $entity);
    }

    /**
     * Main Image
     *
     * @param $data
     * @param Category $entity
     */
    protected function applyImage ($data, Category $entity)
    {
        $image = null;

        if (!empty ($data ['image'] ['id']))
        {
            $image = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Platform\Entity\Media')
                ->find (array ('id' => $data ['image'] ['id']));
        }

        $entity->attachImage ($image);
    }

    /**
     * Handle Locales
     *
     * @param $data
     * @param Category $entity
     */
    protected function applyLocales ($data, Category $entity)
    {
        foreach ($data['locales'] as $localeCode => $localeData)
        {
            $locale = $entity->getLocaleByLanguageCode ($localeCode);

            $this
                ->hydrator
                ->hydrate ($localeData, $locale);

            if (!$locale->getId ())
            {
                $locale->addCategory ($entity);
                $entity->addLocale ($locale);
            }
        }

    }

}