<?php

namespace MotoStore\Product\Form;


use MotoStore\Platform\Doctrine\Strategy\DateTimeStrategy;
use MotoStore\Platform\Form\Filter\DefaultValue;
use MotoStore\Platform\Form\FormTypeAbstract;
use MotoStore\Product\Entity\Option;
use MotoStore\Product\Entity\OptionValue;
use MotoStore\Product\Entity\Product;
use MotoStore\Product\Entity\Property;
use MotoStore\Product\Entity\Property\Relation;
use MotoStore\Product\Entity\Variant;
use Zend\InputFilter\CollectionInputFilter;

class CustomOptionType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array (
        );
    }

    /**
     * Build Form
     */
    public function init ()
    {
        $zero = new DefaultValue (0);

        $this
            ->add (array (
                'name'      => 'id',
                'required'  => false,
                'filters'   => array ($zero),
            ))
            ->add (array (
                'name'      => 'product_id',
                'required'  => false,
                'filters'   => array ($zero),
            ))
            ->add (array (
                'name'      => 'position',
                'required'  => false,
                'filters'   => array ($zero),
            ))
            ->add (array (
                'name'      => 'name',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 0,
                            'max' => 256,
                        )
                    )

                ),
            ))
            ->add (array (
                'name'      => 'type',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 0,
                            'max' => 256,
                        )
                    )

                ),
            ))
            ->add (array (
                'name'      => 'price',
                'required'  => true,
                'filters'   => array ($zero),
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ));
    }

}