<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product\Form;


use MotoStore\Platform\Form\FormTypeAbstract;

class LocaleType extends FormTypeAbstract
{
    public function init()
    {
        $this
            ->add (array (
                'name'      => 'name',
                'required'  => true,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array (
                        'name' => 'StringLength',
                        'options' => array (
                            'min' => 1,
                            'max' => 256,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'keywords',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array (
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 1,
                            'max' => 256,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'meta_description',
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'required'  => false,
                'validators'=> array (
                    array (
                        'name' => 'StringLength',
                        'options' => array (
                            'min' => 1,
                            'max' => 256,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'short_description',
                'required'  => false,
                'filters'  => array (
                    array ('name' => 'StripTags'),
                    array ('name' => 'StringTrim'),
                ),
                'validators'=> array (
                    array (
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 1,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'description',
                'filters'  => array(
                    array ('name' => 'StripTags'),
                    array ('name' => 'StringTrim'),
                ),
                'required'  => false,
                'validators'=> array (
                    array (
                        'name' => 'StringLength',
                        'options' => array (
                            'min' => 1,
                        )
                    )
                ),
            ));
    }

    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array ();
    }


}