<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product\Form;


use MotoStore\Platform\Doctrine\Strategy\DateTimeStrategy;
use MotoStore\Platform\Form\Filter\DefaultValue;
use MotoStore\Platform\Form\FormTypeAbstract;
use MotoStore\Product\Entity\Option;
use MotoStore\Product\Entity\OptionValue;
use MotoStore\Product\Entity\Product;
use MotoStore\Product\Entity\Property;
use MotoStore\Product\Entity\Property\Relation;
use MotoStore\Product\Entity\Variant;
use Zend\InputFilter\CollectionInputFilter;

class VariantType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array (
        );
    }

    /**
     * Build Form
     */
    public function init ()
    {
        $zero = new DefaultValue (0);

        $this
            ->add (array (
                'name'      => 'id',
                'required'  => false,
                'filters'   => array ($zero),
            ))
            ->add (array (
                'name'      => 'product_id',
                'required'  => false,
                'filters'   => array ($zero),
            ))
            ->add (array (
                'name'      => 'sku',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 128,
                        )
                    )

                ),
            ))
            ->add (array (
                'name'      => 'quantity',
                'filters'   => array ($zero),
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'price',
                'required'  => true,
                'filters'   => array ($zero),
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ));
    }

    /**
     * @param $data
     * @param Variant $entity
     */
    protected function onDataValid (&$data, $entity)
    {
        /** @var Product $product */
        $product = $this
            ->getEntityManager ()
            ->getRepository ('MotoStore\Product\Entity\Product')
            ->find ($entity->getProductId ());


        if ($product)
        {
            $this->attachMedia ($data, $entity);
            $this->updateVariantsOption ($data['options'], $entity, $product);

            $entity->setProduct ($product);
            $product->getVariants()
                ->add ($entity);

            $this
                ->getEntityManager ()->merge ($product);
        }



    }

    /**
     * Attach Media to the variant
     * @param $data
     * @param Variant $entity
     */
    private function attachMedia ($data, Variant $entity)
    {
        $image = null;

        if (!empty ($data ['image'] ['id']))
        {
            $image = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Platform\Entity\Media')
                ->find (array ('id' => $data ['image'] ['id']));
        }


        $entity->setImage ($image);

    }

    /**
     * @param $options
     * @param Variant $productVariant
     * @param Product $entity
     */
    private function updateVariantsOption ($options, $productVariant, $entity)
    {

        foreach ($options as $option)
        {
            $variantOption = $productVariant->getOptionByOptionId ($option ['id']);
            $variantOption = $variantOption
                ? $variantOption
                : new Variant\VariantOption ();

            $productOption = $entity->getOption($option ['id']);

            /**
             * If option dosent exists skip
             */
            if (empty($variantOption))
            {
                continue;
            }


            $variantOption->setOption($productOption);
            $variantOption->setVariant($productVariant);


            $select_ = empty($option ['selectedValue'] ['id']) ? 0 : $option ['selectedValue'] ['id'];
            $selectedValue = $productOption->getValue ($select_);

            /**
             * If value dosent exists skip
             */
            if (empty($selectedValue))
            {
                continue;
            }

            $variantOption->setValue ($selectedValue);


            $productVariant->getOptions ()->add ($variantOption);
        }

    }
}