<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Link;


use Moto;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Content\Helper\Link;

class Product extends Moto\ClickAction\AbstractClickAction
{
    protected $_defaultData = array(
        'id' => null,
        'target' => '_self',
        'nofollow' => 0,
    );

    public function getUrl ()
    {
        $url        = '';
        $identifier = $this->get ('id');


        if (empty ($identifier))
        {
            return $url;
        }

        /** @var \MotoStore\Product\Entity\Product $product */
        $product = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Product\Entity\Product')
            ->find ($identifier);

        if ($product)
        {
            $url = Link::storeLink (Link::URI_SECTION_PRODUCT, $product->getUri ());

        }

        if (!empty ($this->_data['anchor']))
        {
            $url .= '#' . $this->_data['anchor'];
        }
        return $url;
    }

    /**
     * @param $url
     * @param null $query
     * @return string
     */
    public static function buildUrl ($url, $query = null)
    {
        if (is_array($query)) {
            $query = http_build_query($query);
        } else {
            $query = '';
        }

        if (!empty($url)) {
            if (self::$_usingPermalinks) {
                if (self::$_usingHtmlSuffix) {
                    $url .= '.html';
                } else {
                    $url = rtrim($url, '/') . '/';
                }
            }
            else {
                $url = ltrim($url, '/');
                $url = '?url=' . $url;
            }
        }

        if (!empty($query)) {
            if (self::$_usingPermalinks) {
                $url .= '?' . $query;
            } else {
                $url .= '&' . $query;
            }
        }
        return $url;
    }
}