<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Service;


use MotoStore\Collection\AbstractImport;
use MotoStore\Product\Entity\Brand;
use MotoStore\Product\Entity\Category\Locale;
use MotoStore\Product\Entity\CustomOption;
use MotoStore\Product\Entity\Option;
use MotoStore\Product\Entity\OptionValue;
use MotoStore\Product\Entity\Variant;
use MotoStore\Product\Entity\Related;
use MotoStore\Product\Entity\Variant\VariantOption;
use MotoStore\Product\Entity\Product;
use MotoStore\Product\Entity\Property;
use MotoStore\Product\Entity\Property\Relation as Relation;
use MotoStore\Product\Entity\Property\Value as PropertyValue;
use MotoStore\Product\Form\CustomOptionType;
use MotoStore\Product\Form\ProductType;
use MotoStore\Product\Form\PropertyType;
use MotoStore\Product\Form\VariantType;

class Import extends AbstractImport
{
    /** @var string use only EN locale */
    private static $locale = 'en';

    /** @var array  */
    private $cachedBrand = array ();

    private $cachedCategories = array ();

    /**
     * Count of updated entities
     * @var int
     */
    private $updatedCounter = 0;

    /**
     * Count of inserted elements
     * @var int
     */
    private $insertedCounter = 0;

    private $settings;
    /**
     * Count of filed entities
     * @var int
     */
    private $failedCounter = 0;


    protected function getHeaders()
    {
        return array (
            'id',
            'type',
            'action',
            'product_id',
            'sku',
            'upc',
            'badge',
            'brand',
            'uri',
            'created_date',
            'name',
            'image',
            'categories',
            'tax_class_id',
            'wholesale_price',
            'price',
            'special_price',
            'has_special_price',
            'special_date_start',
            'special_date_end',
            'weight',
            'length',
            'width',
            'depth',
            'quantity',
            'visibility',
            'keywords',
            'meta_description',
            'short_description',
            'description',
            'custom_option_id',
            'custom_option_product_id',
            'custom_option_position',
            'custom_option_name',
            'custom_option_price',
            'custom_option_type',
            'variation_id',
            'variation_sku',
            'variation_params_view_only',
            'variation_price',
            'variation_quantity',
            'property_property_id',
            'property_value_id',
            'property_value',
            'property_position',
            'property_name',
            'related_product_id',
            'related_product_name',
            'video_uri',
            'shipping_type',
            'shipping_fixed_price',
            'og_image',
            'og_title',
            'og_url',
            'og_description',


        );
    }

    protected function preimportProcess ()
    {
        $this->cacheManufacturesData ();
        $this->cacheCategoriesData ();
    }


    public  function getStingGlue(){
        return $this->settings['excel_compatible']?',':';';
    }

    public  function  getValuesSeparator(){
        return $this->settings['excel_compatible']?';':',';
    }
    /**
     * @param array $data
     * @return null|object
     */
    protected function getUpdateEntity($data = array())
    {

        if($data['type']== 'variation'){
            $repository = $this->entityManager
                ->getRepository ('MotoStore\Product\Entity\Variant');

            $entity = null;

            if (!empty ($data ['variation_id']))
            {
                $entity = $repository->find($data ['variation_id']);
            }

        } else if ($data['type']== 'custom_option') {
            $repository = $this->entityManager
                ->getRepository ('MotoStore\Product\Entity\CustomOption');

            $entity = null;

            if (!empty ($data ['custom_option_id']))
            {
                $entity = $repository->find($data ['custom_option_id']);
            }

        }else if ($data['type']== 'related') {
            $repository = $this->entityManager
                ->getRepository ('MotoStore\Product\Entity\Product');

            $entity = null;

            if (!empty ($data ['product_id']))
            {
                $entity = $repository->find($data ['product_id']);
            }


        } else if ($data['type']== 'property') {
            $repository = $this->entityManager
                ->getRepository ('MotoStore\Product\Entity\CustomOption');

            $entity = null;

            if (!empty ($data ['custom_option_id']))
            {
                $entity = $repository->find($data ['custom_option_id']);
            }

        } else {
            $repository = $this->entityManager
                ->getRepository ('MotoStore\Product\Entity\Product');

            $entity = null;

            if (!empty ($data ['product_id']))
            {
                $entity = $repository->find($data ['product_id']);
            }
            if (($data['action'] == 'add')){
                $entity = $this->getImportEntityPrototype ();
            }



        }
        return $entity;
    }


    public function importLine($data, $settings, $prev_id){


        $this->settings = $settings;

        $entity = $this->getUpdateEntity($data);

        try
        {
            //error_log(json_encode($data));
            if ($data['type'] == 'variation'){
                $result = $this->handleVariant ($entity, $data, $prev_id);
            } else if ($data['type'] == 'custom_option'){
                $result =  $this->handleCustomOption ($entity, $data, $prev_id);
            } else if ($data['type'] == 'related'){
                $result =  $this->handleRelated ($entity, $data, $prev_id);
            } else if ($data['type'] == 'property'){
                $result =  $this->handleProperty ($data, $prev_id);
            } else {


                $result = $this->handleProduct ($entity, $this->transform ($data));
            }
        }
        catch (\Exception $e)
        {
            $result = false;
                error_log (sprintf ('Store import error %s: %s ', get_class ($this->getImportEntityPrototype ()), $e->getMessage ()));
            error_log ('Store Import Data : ' . var_export ($data, true));
        }
        return $result;

    }

    /**
     * @param $entity
     * @param $data
     * @return bool
     */
    protected function handle ($entity, $data)
    {


        $type = new ProductType ();
        $type
            ->setEntityManager ($this->entityManager)
            ->init ();

        return $type->handle ($data, $entity);
    }

    protected function handleProduct ($entity, $data)
    {

        if($data['action'] =='remove'){
            if(!empty($entity)) {
                $this->entityManager->remove($entity);
                $this->entityManager->flush();
                return  ['success'=>true];
            }
            return  ['success'=>true];
        }


        unset($data['action']);


        $type = new ProductType ();
        $type
            ->setEntityManager ($this->entityManager)
            ->init ();
        $result =$type->handle ($data, $entity);
        return  ['success'=>$result, 'product_id' => $entity->getId()];
    }

    protected function handleVariant ($entity, $data,$prev_id)
    {

        if($data['action'] =='remove'){
            if(!empty($entity)) {
                $this->entityManager->remove($entity);
                $this->entityManager->flush();
                return  ['success'=>true];
            }
            return  ['success'=>true];
        }
        if($data['action'] =='add'){

            $em = $this->entityManager;
            $variant = array(
                'sku' => $data['variation_sku'],
                'price' => $data['variation_price'],
                'product_id' => $data['product_id'],
                'quantity' => $data['variation_quantity'],
            );
            /** @var MotoStore\Product\Entity\Product $product */

            $product = $em
                ->getRepository ('MotoStore\Product\Entity\Product')
                ->find($variant['product_id']);

            /** @var Variant $entity */
            $entity = new Variant();
            $entity->setPrice($variant['price']);
            $entity->setProduct($product);
            $em->persist($entity);


            $options = json_decode($data['variation_params_view_only'],true);

            if (is_array($options)){
                foreach ($options as $varoption){

                    $option = $em
                        ->getRepository ('MotoStore\Product\Entity\Option')
                        ->findOneBy(array(
                            'name' => $varoption['option'],
                        ));
                    if (!$option){
                        /** @var Option $option */
                        $option = new Option();
                        $option->setProduct($product);
                        $option->setPosition(0);
                        $option->setName($varoption['option']);
                        $em->persist($option);
                    }

                    $opt_value = $em
                        ->getRepository ('MotoStore\Product\Entity\OptionValue')
                        ->findOneBy(array(
                            'name' => $varoption['value'],
                        ));
                    if (!$opt_value){
                        /** @var OptionValue $opt_value */
                        $opt_value = new OptionValue ();
                        $opt_value->setOption($option);
                        $opt_value->setName($varoption['value']);
                        $em->persist($opt_value);
                    }

                    /** @var VariantOption $variant_option */
                    $variant_option = new VariantOption();


                    $variant_option->setOption($option);
                    $variant_option->setValue($opt_value);
                    $variant_option->setVariant($entity);
                    $em->persist($variant_option);



                }
            }



            $em->flush();

            return  ['success'=>true];
        }


        $variant = array(
            'sku' => $data['variation_sku'],
            'price' => $data['variation_price'],
            'product_id' => $data['product_id'],
            'quantity' => $data['variation_quantity'],
        );


        $type = new VariantType ();
        $type
            ->setEntityManager ($this->entityManager)
            ->init ();

        return $type->handle ($variant, $entity);
    }


    protected function handleCustomOption ($entity, $data, $prev_id)
    {
        if($data['action'] =='remove'){
            if(!empty($entity)) {
                $this->entityManager->remove($entity);
                $this->entityManager->flush();
                return  ['success'=>true];
            }
            return  ['success'=>true];
        }
        if($data['action'] =='add'){
            $em = $this->entityManager;
            $cutom_option = array(
                'name' => $data['custom_option_name'],
                'price' => $data['custom_option_price'],
                'product_id' => (isset($data['product_id'])&&$data['product_id'] !== '')?$data['product_id']:$prev_id,
                'position' => $data['custom_option_position'],
                'type' => $data['custom_option_type'],
            );
            /** @var MotoStore\Product\Entity\Product $product */

            $product = $em
                ->getRepository ('MotoStore\Product\Entity\Product')
                ->find($cutom_option['product_id']);

            /** @var CustomOption $entity */
            $entity = new CustomOption();
            $entity->setPosition(0);
            $entity->setProduct($product);
            $entity->setName($cutom_option['name']);
            $entity->setType($cutom_option['type']);
            $entity->setPrice($cutom_option['price']);
            $em->persist($entity);
            $em->flush();
            return  ['success'=>true];
        }
        $cutom_option = array(
            'name' => $data['custom_option_name'],
            'price' => $data['custom_option_price'],
            'product_id' => (isset($data['product_id'])&&$data['product_id'] !== '')?$data['product_id']:$prev_id,
            'position' => $data['custom_option_position'],
            'type' => $data['custom_option_type'],
        );

        $type = new CustomOptionType ();
        $type
            ->setEntityManager ($this->entityManager)
            ->init ();

        return $type->handle ($cutom_option, $entity);
    }



    protected function handleProperty ($data, $prev_id)
    {
        if ($data['action'] == 'update'){
            $em = $this->entityManager;
            $relation = $em
            ->getRepository ('MotoStore\Product\Entity\Property\Relation')
            ->findOneBy (array('property_id' => $data['property_property_id'],'product_id'=>$data['product_id']));

            /** @var MotoStore\Product\Entity\Property\Relation $relation */
            if($relation){
                $relation->setValueId($data['property_value_id']);
                $em->flush();
            }
            return  ['success'=>true];
        } else if($data['action'] == 'add'){
            $em = $this->entityManager;

            /** @var Relation $relation */
            $relation = new Relation();
            /** @var MotoStore\Product\Entity\Product $product */
            $product = $em
                ->getRepository ('MotoStore\Product\Entity\Product')
                ->find($prev_id);
            /** @var Property $property_entity */
            $property_entity = $em
                ->getRepository ('MotoStore\Product\Entity\Property')
                ->findOneBy(array(
                    'name' => $data['property_name'],
                ));
            if (!$property_entity){
                $property_entity = new Property ();
                $property_entity->setName($data['property_name']);
                $em->persist($property_entity);
            }
            /** @var Property\Value $property_value */
            $property_value = $em
                ->getRepository ('MotoStore\Product\Entity\Property\Value')
                ->findOneBy(array(
                    'value' => $data['property_value'],
                ));
            if (!$property_value){
                $property_value = new PropertyValue ();
                $property_value->setProperty($property_entity);
                $property_value->setValue($data['property_value']);
                $em->persist($property_value);
            }

            $relation->setProduct($product);
            $relation->setProperty($property_entity);
            $relation->setValue($property_value);
            $relation->setPosition(0);
            $em->persist($relation);
            $em->flush();
            return  ['success'=>true];
        } else if($data['action'] == 'remove'){
            $em = $this->entityManager;
            /** @var Relation $relation */
            $relation = $em->getRepository ('MotoStore\Product\Entity\Property\Relation')
                ->findOneBy(array(
                    'product_id' => $data['product_id'],
                    'property_id' => $data['property_property_id']
                ));
            $product = $em
                ->getRepository ('MotoStore\Product\Entity\Product')
                ->find($data ['product_id']);
            if($relation && $product){
                $product->removeProperty($relation);
                $em->flush();
            }
            return  ['success'=>true];
        }
        return  ['success'=>true];
    }

    protected function handleRelated ($entity, $data, $prev_id)
    {
        if ($data['action'] == 'update'){
           // related_product_id;
            return  ['success'=>true];
        } else if($data['action'] == 'add'){
            $em = $this->entityManager;
            $product = $em
                ->getRepository ('MotoStore\Product\Entity\Product')
                ->find($prev_id);

            /** @var Related $related */
            $related = $em
                ->getRepository ('MotoStore\Product\Entity\Related')
                ->findOneBy (array('main_product_id' => $data['product_id'],'product_id'=>$data['related_product_id']));


            if($related){
                $related = new Related();
                $related->setProductId($data['related_product_id']);
                $related->setMainProduct($product);
                $em->persist($related);
            }
            $em->flush();
            return  ['success'=>true];

        } else if($data['action'] == 'remove'){
            $em = $this->entityManager;
            /** @var Product $product */
            $product = $em
                ->getRepository ('MotoStore\Product\Entity\Product')
                ->find($prev_id);

            /** @var Related $related */
            $related = $em
                ->getRepository ('MotoStore\Product\Entity\Related')
                ->findOneBy (array('main_product_id' => $data['product_id'],'product_id'=>$data['related_product_id']));
            if($related && $product){
                $product->removeRelated($related);
                $em->flush();
            }
            return  ['success'=>true];
        }
        return  ['success'=>true];
    }


    /**
     * @param array $data
     * @return array
     */
    protected function transform ($data = array())
    {
        //error_log(json_encode($data));
        $data['id'] = $data['product_id'];
        if ($data['action'] == 'add'){
            $data['id'] = '';
            $data['product_id'] = '';
        }
        $keys_to_unset = array(
            'type',
            'product_id',
            'custom_option_type',
            'related',
            'tier_prices',
            'options',
            'custom_option_id',
            'custom_option_name',
            'custom_option_price',
            'custom_option_product_id',
            'custom_option_position',
            'custom_option_type',
            'variation_id',
            'variation_sku',
            'variation_params_view_only',
            'variation_price',
            'variation_quantity',
            'property_property_id',
            'property_value_id',
            'property_value',
            'property_position',
            'related_product_id',
            'related_product_name',
        );

        foreach ($keys_to_unset as $key){
            unset($data[$key]);
        }

        // Collect locales data
        $localeData = array (
            'name'              => $data ['name'],
            'keywords'          => $data ['keywords'],
            'description'       => $data ['description'],
            'short_description' => $data ['short_description'],
            'meta_description'  => $data ['meta_description'],
        );

        $data ['locales'] = array (self::$locale => $localeData);

        // collect main image data
        if (!empty ($data ['image']))
        {
            $image = $this->entityManager
                ->getRepository ('MotoStore\Platform\Entity\Media')
                ->findOneBy (array ('path' => $data ['image']));

            if ($image)
            {
                $data ['image'] = array ('id' => $image->getId ());
            }
        }

        // collect brand data
        if (!empty ($data ['brand']))
        {
            if (isset ($this->cachedBrand [$data ['brand']]))
            {
                $data ['brand'] = array ('id' => $this->cachedBrand [$data ['brand']]);
            }
        }

        if (!empty($data ['categories']))
        {
            $categoryList = array_filter (explode ($this->getStingGlue(), $data ['categories']));
            $data ['categories'] = array ();

            foreach ($categoryList as $categoryName)
            {
                if (isset ($this->cachedCategories [$categoryName]))
                {
                    $data ['categories'] [$this->cachedCategories [$categoryName]]  = 1;
                }
            }
        }

        return $data;
    }
    /**
     * Proceed data import
     *
     * @param $data
     */
    protected function proceedData ($data)
    {
        // Flag for update session
        $isUpdate = false;

        $entity = $this->getUpdateEntity ($data);

        (empty ($entity) && ($data['type'] == 'product'))
            ? $entity = $this->getImportEntityPrototype ()
            : $isUpdate = true;

        try
        {
            //error_log(json_encode($data));
            if ($data['type'] == 'variation'){
                $isError = !$this->handleVariant ($entity, $data,0);
            } else if ($data['type'] == 'custom_option'){
               $isError = !$this->handleCustomOption ($entity, $data,0);
            } else {
                $isError = !$this->handleProduct ($entity, $this->transform ($data));
            }
            $this->updateCounters ($isUpdate, $isError);
        }
        catch (\Exception $e)
        {
            $this->updateCounters ($isUpdate, true);

            error_log (sprintf ('Store import error %s: %s ', get_class ($this->getImportEntityPrototype ()), $e->getMessage ()));
            error_log ('Store Import Data : ' . var_export ($data, true));
        }

    }


    /**
     * Update import session counters
     *
     * @param $isUpdate
     * @param $isError
     */
    private function updateCounters ($isUpdate, $isError = false)
    {
        if ($isError)
        {
            ++$this->failedCounter;

            return;
        }

        $isUpdate
            ? ++$this->updatedCounter
            : ++$this->insertedCounter;
    }


    protected function getImportEntityPrototype()
    {
        return new Product ();
    }

    /**
     * Cache Brands
     */
    private function cacheManufacturesData ()
    {
        $brands = $this
            ->entityManager
            ->getRepository ('MotoStore\Product\Entity\Brand')
            ->findAll ();

        /** @var Brand $brand */
        foreach ($brands as $brand)
        {
            $this->cachedBrand [$brand->getName ()] = $brand->getId ();
        }

        unset ($brands);
    }

    /**
     * Cache categories
     */
    private function cacheCategoriesData ()
    {
        $categories = $this
            ->entityManager
            ->getRepository ('MotoStore\Product\Entity\Category\Locale')
            ->findAll ();
        /** @var Locale $locale */
        foreach ($categories as $locale)
        {
            $this->cachedCategories [$locale->getName ()] = $locale->getCategoryId ();
        }
        unset($categories);
    }

    public function analyzeFile($file,$settings){

        $glue = $settings['excel_compatible']?';':',';
        $headers = '';
        $headersIndexes = array();
        $result = array();
        while ($data = fgetcsv($file,0,$glue))
        {
            //error_log(json_encode($data));
            // Export first row as headers
            if (empty ($headers))
            {
                $validHeaders = array_intersect_key (array_flip ($data), array_flip ($this->getHeaders ()));

                //error_log(json_encode($validHeaders));
                $headersIndexes = array_flip ($validHeaders);
                $headers = array_keys ($validHeaders);
                continue;
            }
            //error_log(json_encode($data));
            // Extract fields with exists headers indexes
            $extractedData  = array_intersect_key ($data, $headersIndexes);
            // Combine with allowed headers
            $combined = array_combine ($headers, $extractedData);
            // proceed row data
            //error_log(json_encode($combined));
            $result [] = $combined;
        }
        return $result;
    }
}