<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Settings\Accessor;


use MotoStore\Settings\Entity\Option;
use MotoStore\Settings\Repository\OptionRepository;

class OptionAccessor
{
    private $repository;

    public function __construct(OptionRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * @return mixed
     */
    public function isStoreHomePageIsHome ()
    {
        return $this->repository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'is_home', false);
    }

    /**
     * @return mixed
     */
    public function isMaintenanceMode ()
    {
        return $this->repository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'maintenance', false);
    }

    /**
     * Is store disabled for serach engine
     * @return bool
     */
    public function isDisableIndexMode ()
    {
        return $this->repository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'noindex', false);
    }
}