<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Collection;


use Doctrine\ORM\QueryBuilder;
use MotoStore\Collection\Collection;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class Discount implements FactoryInterface
{
    /**
     * Create service
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService (ServiceLocatorInterface $serviceLocator)
    {

        $collection = new Collection ();

        /** @var QueryBuilder $queryBuilder */
        $queryBuilder = $serviceLocator
            ->get ('MotoStore\EntityManager')
            ->createQueryBuilder ();

        $query = $queryBuilder
            ->select (array ('d'))
            ->from ('MotoStore\Settings\Entity\Discount', 'd');

        $collection->setQuery ($query);

        $collection->setPropertiesMap (array (
            'code'          => 'd.code',
            'type'          => 'd.type',
            'date_start'    => 'd.date_start',
            'date_end'      => 'd.date_end',
            'active'        => 'd.active',
            'usage'         => 'd.usage',
            'quantity'      => 'd.quantity',
            'value'      => 'd.value',
        ));

        return $collection;
    }
}