<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Settings\Entity;

use Doctrine\ORM\Mapping as ORM;


/**
 * @ORM\Entity
 * @ORM\Table (name="store_discount",options={"engine":"InnoDB"})
 */
class Discount
{

    const DISCOUNT_TYPE_PERCENT     = 1;
    const DISCOUNT_TYPE_AMOUNT      = 2;


    public static  function getDiscountsTypes ()
    {
        return array(
            self::DISCOUNT_TYPE_PERCENT => 'By Percentage of the Original Price',
            self::DISCOUNT_TYPE_AMOUNT   => 'By Fixed Amount',
        );
    }

    /**
     * @param string $code_prefix
     * @return string
     */
    public static function generateDiscountCode($code_prefix = '')
    {
        return uniqid($code_prefix);
    }

    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /** @ORM\Column(type="integer") */
    protected $type;

    /** @ORM\Column(type="string") */
    protected $code;

    /** @ORM\Column(type="date") */
    protected $date_start;

    /** @ORM\Column(type="date") */
    protected $date_end;

    /** @ORM\Column(type="integer") */
    protected $quantity;

    /** @ORM\Column(type="integer", name="`usage`") */
    protected $usage;

    /** @ORM\Column(type="boolean") */
    protected $active;

    /** @ORM\Column(type="boolean") */
    protected $apply_to_shipping;

    /** @ORM\Column(name="`value`", type="integer") */
    protected $value;

    public function getDiscountString ()
    {
        $string = '-' . $this->getValue ();

        if ( $this->getValue () == self::DISCOUNT_TYPE_PERCENT )
        {
            $string = $string . '%';
        }

        return $string;
    }

    /**
     * @param mixed $date_end
     */
    public function setDateEnd ($date_end)
    {
        $this->date_end = $date_end;
    }

    /**
     * @return mixed
     */
    public function getDateEnd ()
    {
        if($this->date_end)
        {
            return $this->date_end;
        }

        return new \DateTime();
    }

    /**
     * @param mixed $date_start
     */
    public function setDateStart($date_start)
    {
        $this->date_start = $date_start;
    }

    /**
     * @return mixed
     */
    public function getDateStart()
    {
        if($this->date_start)
        {
            return $this->date_start;
        }

        return new \DateTime();
    }

    /**
     * @param mixed $discount_code
     */
    public function setCode ($discount_code)
    {
        $this->code = $discount_code;
    }

    /**
     * @return mixed
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param mixed $discount_type
     */
    public function setType($discount_type)
    {
        $this->type = $discount_type;
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param mixed $discount_value
     */
    public function setValue($discount_value)
    {
        $this->value = $discount_value;
    }

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $is_active
     */
    public function setActive($is_active)
    {
        $this->active = $is_active;
    }

    /**
     * @return mixed
     */
    public function isActive()
    {
        return $this->active;
    }
    /**
     * @param mixed $value
     */
    public function setApplyToShipping($value)
    {
        $this->apply_to_shipping = $value;
    }

    /**
     * @return mixed
     */
    public function isApplyToShipping()
    {
        return $this->apply_to_shipping;
    }

    /**
     * @param mixed $quantity
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;
    }

    /**
     * @return mixed
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param mixed $used_quantity
     */
    public function setUsage($used_quantity)
    {
        $this->usage = $used_quantity;
    }

    /**
     * @return mixed
     */
    public function getUsage()
    {
        return $this->usage;
    }

    public function getDiscountedValue( $value  = 0)
    {
        $discounted_value = $value;

        switch ( $this->getType() )
        {
            case self::DISCOUNT_TYPE_PERCENT :
                $discounted_value = $value - ($value * $this->getValue()/100);
                break;
            case self::DISCOUNT_TYPE_AMOUNT :
                $discounted_value = $value - $this->getValue();
                break;
        }

        return $discounted_value;
    }

    public function trackUsage ($usage = 1)
    {
        $this->setUsage ($this->getUsage () + $usage);
    }
}