<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class ModuleOption
 * @package MotoStore\Platform\Entity
 * @ORM\Entity(repositoryClass="MotoStore\Settings\Repository\OptionRepository")
 * @ORM\Table(name="store_option",options={"engine":"InnoDB"} , uniqueConstraints={@ORM\UniqueConstraint(name="option_unique_idx", columns={"module_name", "option_key"})})
 */
class Option
{
    const OPTION_STORE_SETTINGS_PRODUCT = 'storesettings_product';
    const OPTION_STORE_SETTINGS_SHIPPING = 'storesettings_shipping';
    const OPTION_STORE_SETTINGS_CHECKOUT = 'storesettings_checkout';
    const OPTION_STORE_SETTINGS_DISCOUNTS = 'storesettings_discounts';
    const OPTION_STORE_SETTINGS_SLIDER = 'storesettings_slider';
    const OPTION_STORE_SETTINGS_MAIL = 'storesettings_mail';
    const OPTION_STORE_SETTINGS_SYSTEM = 'storesettings_system';
    const OPTION_STORE_SETTINGS_DESIGN = 'storesettings_design';
    const OPTION_STORE_SETTINGS_INVOICES = 'storesettings_invoices';
    const OPTION_STORE_SETTINGS_INTEGRATIONS = 'storesettings_integrations';
    const OPTION_STORE_SETTINGS_EXTENTIONS = 'storesettings_extentions';
    const OPTION_STORE_SETTINGS_WORKING_HOURS = 'storesettings_workinghours';

    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /** @ORM\Column(type="string") */
    protected $module_name;

    /** @ORM\Column(type="string") */
    protected $option_key;

    /** @ORM\Column(type="text") */
    protected $option_value;

    public function __construct ($module = null, $option = null, $value = null)
    {
        $this
            ->setModuleName($module)
            ->setOptionKey ($option)
            ->setOptionValue ($value);
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return $this
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getModuleName()
    {
        return $this->module_name;
    }

    /**
     * @param mixed $module_name
     * @return $this
     */
    public function setModuleName($module_name)
    {
        $this->module_name = strtolower ($module_name);

        return $this;
    }

    /**
     * @return mixed
     */
    public function getOptionKey()
    {
        return $this->option_key;
    }

    /**
     * @param mixed $option_key
     * @return $this
     */
    public function setOptionKey($option_key)
    {
        $this->option_key = $option_key;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getOptionValue()
    {
        return $this->option_value;
    }

    /**
     * @param mixed $option_value
     * @return $this
     */
    public function setOptionValue($option_value)
    {
        $this->option_value = $option_value;
        return $this;
    }
}