<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Settings\Entity\Tax;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="store_tax_zone",options={"engine":"InnoDB"})
 */
class Zone
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /** @ORM\Column(type="string", length=45) */
    protected $name;

    /** @ORM\Column(type="boolean") */
    protected $enabled;

    /**
     * @ORM\OneToMany(targetEntity="MotoStore\Settings\Entity\Tax\Region", mappedBy="zone", cascade={"persist", "remove", "merge"})
     * @var \Doctrine\Common\Collections\ArrayCollection
     */
    protected $regions;

    /**
     * @ORM\OneToMany(targetEntity="MotoStore\Settings\Entity\Tax\Rate", mappedBy="zone", cascade={"persist", "remove", "merge"})
     */
    protected $rates;

    public function __construct ()
    {
        $this->regions    = new ArrayCollection ();
        $this->rates      = new ArrayCollection ();
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return mixed
     */
    public function getEnabled()
    {
        return $this->enabled;
    }

    /**
     * @param mixed $enabled
     */
    public function setEnabled($enabled)
    {
        $this->enabled = $enabled;
    }

    /**
     * @return ArrayCollection
     */
    public function getRegions()
    {
        return $this->regions;
    }

    /**
     * @param ArrayCollection $regions
     */
    public function addRegion($regions)
    {
        $this->regions->add ($regions);
    }

    /**
     * @return mixed
     */
    public function getRates()
    {
        return $this->rates;
    }

    /**
     * @param mixed $rates
     */
    public function addRate ($rates)
    {
        $this->rates->add ($rates);
    }
}