<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Form;


use MotoStore\Platform\Form\Filter\DefaultValue;
use MotoStore\Platform\Form\FormTypeAbstract;

class CurrencyType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array (
        );
    }

    /**
     * Build Form
     */
    public function init ()
    {
        $this
            ->add (array (
                'name'      => 'location',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 1,
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'name',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 1,
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'code',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 3,
                            'max' => 3,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'exchange_rate',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'token',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 1,
                            'max' => 4,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'decimal_point',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 1,
                            'max' => 1,
                        )
                    )
                ),
            ))
            ->add(array (
                'name'      => 'thousands_separator',
                'required'  => false,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 1,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'decimal_places',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'Digits',
                    )

                ),
            ))
            ->add (array (
                'name'      => 'active',
                'required'  => false,
                'filters'=> array (
                    new DefaultValue (0)
                ),
            ))
        ->add (array (
        'name'      => 'spacer',
        'required'  => false,
        'filters'=> array (
            new DefaultValue (0)
        ),
    ));
    }

}