<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Repository;

use Doctrine\ORM\EntityRepository;
use MotoStore\Order\Cart\Storage;
use MotoStore\Settings\Entity\Currency;
use MotoStore\Settings\Entity\Option;

class CurrencyRepository extends EntityRepository
{

    /**
     * @var array
     */
    private $currencies = array ();

    /**
     * @var Currency
     */
    private $defaultCurrency;

    /**
     * Active Currencies
     * @return Currency []
     */
    public function getCurrencies ()
    {
        if (!$this->currencies)
        {
            $this->currencies = $this->fetchCurrencies ();
        }
        return $this->currencies;
    }

    /**
     * @return array
     */
    public function getActiveCurrenciesList ()
    {
        $active = array_map (function (Currency $c) {
            if ($c->getActive ())
            {
                return array (
                    'id'      => $c->getId (),
                    'code'    => $c->getCode (),
                    'token'   => $c->getToken (),
                );
            }
            return null;

        }, $this->getCurrencies ());

        return array_filter ($active);
    }

    /**
     * Return default currency or forced currency
     *
     * @param int $forceCurrencyId
     * @return array
     */
    public function getDefaultCurrency ($forceCurrencyId = 0)
    {
        if (!$forceCurrencyId)
        {
            $forceCurrencyId = $this->_em
                ->getRepository ('MotoStore\Settings\Entity\Option')
                ->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'default_currency', 0);

            return $this->getCurrencyById ($forceCurrencyId);
        }
        else
        {
            if (!$this->defaultCurrency)
            {
                $this->defaultCurrency = $this->getCurrencyById ($forceCurrencyId);
            }
            return $this->defaultCurrency;
        }
    }

    /**
     * Get display currency (selected by customer)
     * @return Currency
     */
    public function getDisplayCurrency ()
    {
        $storage = new Storage ();
        $default = $storage->getCurrency ();
        return $this
            ->getDefaultCurrency ($default);
    }

    /**
     * Fetch options
     *
     * @return array
     */
    private function fetchCurrencies ()
    {
        $query = $this->_em->createQueryBuilder ();

        $query
            ->select (array ('c'))
            ->from ('MotoStore\Settings\Entity\Currency', 'c');

        return $query
            ->getQuery ()
            ->getResult();
    }

    /**
     * @param $id
     * @return Currency
     */
    public function getCurrencyById ($id)
    {
        foreach ($this->getCurrencies () as $currency)
        {
            if ($currency->getId () == $id)
            {
                return $currency;
            }
        }
        return null;
    }
}