<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Repository;

use Doctrine\ORM\EntityRepository;
use MotoStore\Settings\Entity\Option;

class OptionRepository extends EntityRepository
{

    /**
     * @var array
     */
    private $options = array ();

    /**
     * Load module options
     * @param $moduleName
     * @return array
     */
    public function getModuleOptions ($moduleName)
    {
        $moduleName = strtolower ($moduleName);

        if (!$this->options)
        {
            $this->options = $this->fetchOptions ();
        }

        if (array_key_exists ($moduleName, $this->options))
        {
            return $this->options [$moduleName];
        }
        return array ();
    }

    /**
     * Get one option by key
     *
     * @param $moduleName
     * @param $key
     * @param null $default
     * @return mixed
     */
    public function getOption ($moduleName, $key, $default = null)
    {
        $options = $this->getModuleOptions ($moduleName);

        if (array_key_exists ($key, $options))
        {
            return $options[$key];
        }
        return $default;
    }

    /**
     * Create Option
     *
     * @param $moduleName
     * @param $key
     * @param $value
     */
    public function setOption ($moduleName, $key, $value)
    {
        /** @var Option $option */
        $option = $this
            ->_em
            ->getRepository ('MotoStore\Settings\Entity\Option')
            ->findOneBy (array (
                'module_name' => $moduleName,
                'option_key' => $key
            ));

        if ($option)
        {
            $option->setOptionValue ($value);
        }
        else
        {
            $option = new Option ($moduleName, $key, $value);
        }

        $this->_em->persist ($option);
        $this->_em->flush ();
    }

    /**
     * Fetch options
     *
     * @return array
     */
    private function fetchOptions ()
    {
        $query = $this->_em->createQueryBuilder ();

        $query
            ->select (array ('o.option_key', 'o.option_value', 'o.module_name'))
            ->from ('MotoStore\Settings\Entity\Option', 'o');


        $options = $query
            ->getQuery ()
            ->getArrayResult ();

        $result = array ();

        foreach ($options as $option)
        {
            $result [$option ['module_name']][$option ['option_key']] = $option ['option_value'];

        }
        return $result;
    }
}