<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\QueryBuilder;
use MotoStore\Settings\Entity\Tax\Rate;

class TaxRateRepository extends EntityRepository
{
    /**
     * Search tax rate by state
     *
     * @param $tax_class_id
     * @param $state_id
     * @return Rate[]
     */
    public function getRateByState ($tax_class_id, $state_id)
    {
        $q = $this
            ->createBaseRateQuery ($tax_class_id);

        return $q
            ->andWhere ($q->expr ()->eq ('zr.state_id', $state_id))
            ->getQuery()
            ->getResult ();
    }

    /**
     * Search tax rate by country
     *
     * @param $tax_class_id
     * @param $country_id
     * @return Rate[]
     */
    public function getRateByCountry ($tax_class_id, $country_id)
    {
        $q = $this
            ->createBaseRateQuery ($tax_class_id);

        return $q
            ->andWhere ($q->expr ()->eq ('zr.country_id', $country_id))
            ->getQuery()
            ->getResult ();
    }


    /**
     * Create Base Query for Rate
     *
     * @param int $tax_class_id
     * @return QueryBuilder
     */
    private function createBaseRateQuery ($tax_class_id)
    {
        $q = $this
            ->_em
            ->createQueryBuilder ();

        $q
            ->select (array ('r'))
            ->from('MotoStore\Settings\Entity\Tax\Rate', 'r')
            ->leftJoin ('r.zone', 'z')
            ->leftJoin ('z.regions', 'zr')
            ->where ($q->expr ()->eq ('r.class_id', $tax_class_id))
            ->andWhere ($q->expr ()->eq ('z.enabled', 1));

        return $q;
    }



}