<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Service;

use Doctrine\ORM\Query;
use MotoStore\Service\ServiceEditableInterface;
use MotoStore\Service\ServiceReadableInterface;
use MotoStore\Service\StoreServiceAbstract;
use MotoStore\Settings\Entity\Currency;
use MotoStore\Settings\Entity\Option;
use MotoStore\Settings\Form\CurrencyType;

class CurrencyServiceClass extends StoreServiceAbstract implements ServiceReadableInterface, ServiceEditableInterface
{
    /**
     * Prefix of Resource
     *
     * @return mixed
     */
    protected function getPrefix ()
    {
        return 'currency';
    }

    /**
     * Collection Name
     *
     * @return string
     */
    protected function getCollectionName ()
    {
        return 'store.collection.currency';
    }

    /**
     * Save Resource
     *
     * @return mixed
     */
    public function save ()
    {
        return $this
            ->handleUpdateRequest (new CurrencyType (), new Currency ());
    }

    /**
     * Remove Resource
     *
     * @param $id
     * @return mixed
     */
    public function delete ($id)
    {
        $this
            ->handleDeleteRequest ($id);
    }

    /**
     * Retrieve Collection By Params
     *
     * @return mixed
     */
    public function getCollection ()
    {
        $default = $this->getDefault ();

        return $this
            ->handleCollectionRequest (function ($currency) use ($default) {

                $currency ['default'] = $currency ['id'] == $default
                    ? true
                    : false;

                return $currency;
            });
    }

    /**
     * @param int $id
     * @return mixed
     */
    public function getItem ($id)
    {
        $default = $this->getDefault ();

        return $this
            ->collection
            ->setHydrationMode (Query::HYDRATE_ARRAY)
            ->getOne ($id, function (&$currency) use ($default) {
                $currency ['default'] = $currency ['id'] == $default
                    ? true
                    : false;
            });
    }

    private function getDefault ()
    {
        return  $this
            ->collection
            ->getEntityManager ()
            ->getRepository ('MotoStore\Settings\Entity\Option')
            ->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'default_currency');
    }

    public function setActive ()
    {
        $params = $this->_request->getParams ();

        if (!empty ($params ['id']))
        {

            $curr_id     = $params ['id'];
            $active = false;
            if ($params ['active'] == 'true'){
                $active = true;
            }

            $em = $this
                ->collection
                ->getEntityManager ();
            /** @var Currency $entity */
            $entity = $em->getRepository ('MotoStore\Settings\Entity\Currency')
                ->find ($curr_id);
            $entity
                ->setActive($active);

            $em->flush();

        }

    }


}