<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Service;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Query;
use MotoStore\Platform\Application;
use MotoStore\Service\StoreServiceAbstract;
use MotoStore\Settings\Entity\Option;
use MotoStore\Settings\Repository\OptionRepository;
use VisualAppeal\AutoUpdate;
use Zend\ServiceManager\ServiceLocatorInterface;
use Moto;

class SettingsServiceClass extends StoreServiceAbstract
{
    /**
     * @var EntityManager
     */
    protected $entityManager;
    /**
     * @var AutoUpdate
     */
    protected $updateInstance;

    protected $storeConfig;

    protected $_resourcePrivilegesMap = array (
        'getOptions' => 'get',
        'getOption' => 'get',
        'checkUpdate' => 'get',
    );

    public function __construct (ServiceLocatorInterface $serviceLocator)
    {
        $this->applyResourcePrefix ();

        $this
            ->entityManager = $serviceLocator->get ('MotoStore\EntityManager');
        $this
            ->updateInstance = $serviceLocator->get ('store.up.instance');
        $this
            ->storeConfig = $serviceLocator->get ('store.config');
    }

    /**
     * Prefix of Resource
     *
     * @return mixed
     */
    protected function getPrefix ()
    {
        return 'settings';
    }

    /**
     * Collection Name
     *
     * @return string
     */
    protected function getCollectionName ()
    {

    }

    /**
     * Save Resource
     *
     * @return mixed
     */
    public function saveOptions ()
    {
        $name = $this
            ->getParams ()
            ->get('modulename');

        $options = $this
            ->getParams ()
            ->get('options', array ());

        foreach ($options as $key => $value)
        {
            /**
             * @var Option $option
             */
            $option = $this
                ->entityManager
                ->getRepository ('MotoStore\Settings\Entity\Option')
                ->findOneBy (array (
                    'module_name' => $name,
                    'option_key' => $key
                ));

            if (!$option)
            {
                $option = new Option ($name, $key, $value);
                $this
                    ->entityManager->persist ($option);
            }
            else
            {
                $option->setOptionValue ($value);
                $this
                    ->entityManager->merge ($option);

            }
        }
        $this
            ->entityManager
            ->flush ();

        return $options;
    }

    /**
     * Retrieve Collection By Params
     *
     * @return mixed
     */
    public function getOptions ()
    {
        $moduleName = $this
            ->getParams ()
            ->get ('modulename');

        if ($moduleName)
        {
            return $this
                ->getRepository ()
                ->getModuleOptions ($moduleName);
        }
        return array ();
    }

    /**
     * @return mixed
     */
    public function getOption ()
    {
        $moduleName = $this
            ->getParams ()
            ->get ('modulename');

        $id = $this
            ->getParams ()
            ->get ('option');


        if ($moduleName)
        {
            return array(
                'option' => $this->getRepository ()->getOption ($moduleName, $id)
            );
        }
        return array ();
    }

    /**
     * @return OptionRepository
     */
    private function getRepository ()
    {
        return $this
            ->entityManager
            ->getRepository ('MotoStore\Settings\Entity\Option');
    }

    /**
     * Check Latest Version
     *
     * @return array
     */
    public function checkUpdate ()
    {

        $version = Application::CURRENT_VERSION;
        $build = Application::CURRENT_BUILD;
        $response = array (
            'status' => false,
            'version' => null
        );

        if (class_exists('Moto\System\UpdateManager')) {
            $nextUpdate = Moto\System\UpdateManager::getPluginNextUpdate('moto-store-plugin', $version, $build);

            if ($nextUpdate)
            {
                $updateVersion = Moto\Util::getValue($nextUpdate, 'version');
                $response ['status'] = true;
                $response ['version'] = $updateVersion;
            }


        } else {
            $this
                ->updateInstance
                ->setCurrentVersion ($version);


            if (isset($this->storeConfig['settings']['updates']) && $this->storeConfig['settings']['updates'] == false){
                return $response;

            }
            $result = $this
                ->updateInstance
                ->checkUpdate ();
            if ($result)
            {
                $response ['status'] = $this->updateInstance->newVersionAvailable ();
                $response ['version'] = $this->updateInstance->getLatestVersion ()->getVersion ();
            }
        }



        return $response;
    }


    /**
     * Update Version
     * @return array
     */
    public function update ()
    {
        $version = $this
            ->getRepository ()
            ->getOption (Option::OPTION_STORE_SETTINGS_SYSTEM, 'CURRENT_VERSION', Application::CURRENT_VERSION);
        $version_files = Application::CURRENT_VERSION;
        $build = Application::CURRENT_BUILD;

        $this
            ->updateInstance
            ->setCurrentVersion ($version);
        $response = array (
            'status' => false,
            'version' => null
        );
        $result = false;
        if (class_exists('Moto\System\UpdateManager')) {
            $nextUpdate = Moto\System\UpdateManager::getPluginNextUpdate('moto-store-plugin', $version_files, $build);

            if ($nextUpdate)
            {
                $updateVersion = Moto\Util::getValue($nextUpdate, 'version');
                $updateurl = Moto\Util::getValue($nextUpdate, 'url');
                $response ['status'] = true;
                $response ['version'] = $updateVersion;
                $this->updateInstance->setVersionsToUpdate(array(
                    'version' => $updateVersion,
                    'url' => $updateurl,
                ));
                $this->updateInstance->setLatestVersion($updateVersion);
                error_log('before_update');
                $result = $this
                    ->updateInstance
                    ->update (false);
            }
            else
            {
                $response ['status'] = true;
                $response ['message'] = 'STORE.UPDATE.ERROR.NO_UPDATE_AVAILABLE';
            }

        } else {
            $result = $this
                ->updateInstance
                ->checkUpdate ();
            if ($result) {
                if ($this->updateInstance->newVersionAvailable()) {
                    $version = $this->updateInstance->getLatestVersion()->getVersion();

                    $result = $this
                        ->updateInstance
                        ->update(false);
                }
            }
            else
            {
                $response ['status'] = true;
                $response ['message'] = 'STORE.UPDATE.ERROR.NO_UPDATE_AVAILABLE';
            }

        }
        if ($result === true)
        {
            $response['status'] = true;
            $response['message'] = 'STORE.UPDATE.SUCCESS';
        }
        else
        {
            switch ($result)
            {
                case AutoUpdate::ERROR_VERSION_CHECK:
                    $message = 'STORE.UPDATE.ERROR.ERROR_VERSION_CHECK';
                    break;
                case AutoUpdate::ERROR_TEMP_DIR:
                    $message = 'STORE.UPDATE.ERROR.ERROR_TEMP_DIR';
                    break;
                case AutoUpdate::ERROR_INSTALL_DIR:
                    $message = 'STORE.UPDATE.ERROR.ERROR_INSTALL_DIR';
                    break;
                case AutoUpdate::ERROR_INVALID_ZIP:
                    $message = 'STORE.UPDATE.ERROR.ERROR_INVALID_ZIP';
                    break;
                case AutoUpdate::ERROR_DOWNLOAD_UPDATE:
                    $message = 'STORE.UPDATE.ERROR.ERROR_DOWNLOAD_UPDATE';
                    break;
                case AutoUpdate::ERROR_DELETE_TEMP_UPDATE:
                    $message = 'STORE.UPDATE.ERROR.ERROR_DELETE_TEMP_UPDATE';
                    break;
                case AutoUpdate::ERROR_SIMULATE:
                    $message = 'STORE.UPDATE.ERROR.ERROR_SIMULATE';
                    break;
                case AutoUpdate::NO_UPDATE_AVAILABLE:
                    $message = 'STORE.UPDATE.ERROR.NO_UPDATE_AVAILABLE';
                    break;
                case AutoUpdate::ERROR_INSTALL:
                    $message = 'STORE.UPDATE.ERROR.ERROR_INSTALL';
                    break;
                default:
                    $message = 'STORE.UPDATE.ERROR.ERROR_UNKNOWN';

            }

            $response['message'] = $message;
        }



        return $response;
    }
}