<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Service;

use Doctrine\ORM\Query;
use MotoStore\Service\ServiceEditableInterface;
use MotoStore\Service\ServiceReadableInterface;
use MotoStore\Service\StoreServiceAbstract;
use MotoStore\Settings\Entity\Tax\Zone;
use MotoStore\Settings\Form\ZoneType;

class TaxZoneServiceClass extends StoreServiceAbstract implements ServiceReadableInterface, ServiceEditableInterface
{
    /**
     * Prefix of Resource
     *
     * @return mixed
     */
    protected function getPrefix ()
    {
        return 'taxzone';
    }

    /**
     * Collection Name
     *
     * @return string
     */
    protected function getCollectionName ()
    {
        return 'store.collection.tax.zone';
    }

    /**
     * Save Resource
     *
     * @return mixed
     */
    public function save ()
    {
        return $this
            ->handleUpdateRequest (new ZoneType (), new Zone ());
    }

    /**
     * Remove Resource
     *
     * @param $id
     * @return mixed
     */
    public function delete ($id)
    {
        $this
            ->handleDeleteRequest ($id);
    }

    /**
     * Retrieve Collection By Params
     *
     * @return mixed
     */
    public function getCollection ()
    {
        return $this
            ->handleCollectionRequest ();
    }

    /**
     * @param int $id
     * @return mixed
     */
    public function getItem ($id)
    {
        return $this
            ->collection
            ->setHydrationMode (Query::HYDRATE_ARRAY)
            ->getOne ($id);
    }

    public function setEnabled ()
    {
        $params = $this->_request->getParams ();

        if (!empty ($params ['id']))
        {

            $curr_id     = $params ['id'];
            $enabled = false;
            if ($params ['enabled'] == 'true'){
                $enabled = true;
            }

            $em = $this
                ->collection
                ->getEntityManager ();
            /** @var Currency $entity */
            $entity = $em->getRepository ('MotoStore\Settings\Entity\Tax\Zone')
                ->find ($curr_id);
            $entity
                ->setEnabled($enabled);

            $em->flush();

        }

    }
}